% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1d.smooths.r
\name{nearest.point}
\alias{nearest.point}
\title{Identify nearest point in time to a given estimate value}
\usage{
nearest.point(kernel.smooths, density, variant, n = 1, timerange)
}
\arguments{
\item{kernel.smooths}{A list output by kernel.smooth.in.time().}

\item{density}{The value of the dependent variable for which a time is to be identified.}

\item{variant}{If the dependent variable was a factor, which level is being examined (do not give a value if dependent variable was numeric).}

\item{n}{The number of nearest points to be returned (useful if the estimates cross the relevant threshold multiple times, defauls to 1).}

\item{timerange}{Numeric vector of length two - used to restrict search to a specific time range within the kernel.smooth.in.time(), in the form c(min,max).}
}
\value{
One or more numeric values.
}
\description{
This function takes the output of kernel.smooth.in.time and identifies the point in time when the smoothed estimate comes closest to some specific value. This is useful for tasks like identifying the likely midpoint of a change.
}
