% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalization.R
\name{TSS}
\alias{TSS}
\title{Total Sum Scaling}
\usage{
TSS(X, rows = TRUE)
}
\arguments{
\item{X}{Numeric matrix or data.frame of any size containing absolute frequencies.}

\item{rows}{If TRUE, the operation is done by row; otherwise, it is done by
column. (Defaults: TRUE).}
}
\value{
A relative frequency matrix or data.frame with the same dimension than X.
}
\description{
This function transforms a dataset from absolute to relative frequencies
(by row or column).
}
\examples{
dat <- matrix(rnorm(50),ncol=5,nrow=10)
TSS(dat) #It can be checked that, after scaling, the sum of each row is equal to 1.
}
