% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/record.R
\name{keysRecordInput}
\alias{keysRecordInput}
\alias{recordKeys}
\title{Create a keys recorder input control}
\usage{
keysRecordInput(inputId)

recordKeys(inputId, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{inputId}{The input slot that will be used to access the value.}

\item{session}{The \code{session} object passed to function given to
\code{shinyServer}.}
}
\description{
Create a key input that can be used to record keys pressed by
the user.
}
\examples{
if (interactive()) {
  library(shiny)

  ui <- fluidPage(
    useKeys(),
    keysRecordInput("recorder"),
    keysInput("keys", "command+shift+k"),
    actionButton("record", "Record keys")
  )

  server <- function(input, output, session) {
    observeEvent(input$record, {
      print("recording keys...")
      recordKeys("recorder")
    })
    observeEvent(input$recorder, {
      print("adding keys...")
      addKeys("keys", input$recorder)
    })
    observeEvent(input$keys, {
      print(input$keys)
    })
  }

  shinyApp(ui, server)
}
}
