% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_efa.R
\name{run_efa}
\alias{run_efa}
\title{Conducts exploratory factor analysis}
\usage{
run_efa(
  variables,
  m = floor(ncol(variables)/4),
  rotation = "oblimin",
  simple = TRUE,
  threshold = NA,
  single.item = c("keep", "drop", "none"),
  identified = TRUE,
  constrain0 = FALSE,
  ordered = FALSE,
  estimator = NULL,
  missing = "listwise",
  ...
)
}
\arguments{
\item{variables}{a \code{data.frame} (or convertible to a \code{data.frame}) of variables (i.e., items) to factor analyze}

\item{m}{integer; maximum number of factors to extract. Default is 4 items per factor.}

\item{rotation}{character (case-sensitive); any rotation method listed in
\code{\link[GPArotation]{rotations}} in the \code{GPArotation} package.
Default is "oblimin".}

\item{simple}{logical; Should the most simple structure be returned (default)?
If \code{FALSE}, items can cross load on multiple factors.}

\item{threshold}{numeric between 0 and 1 indicating the minimum (absolute) value
of the loading for an item on a factor.}

\item{single.item}{character indicating how single-item factors should be treated.
Use \code{"keep"} (default) to keep them in the model when generating the CFA syntax, \code{"drop"}
to remove them, or \code{"none"} indicating the CFA syntax should not be generated for
this model and \code{""} will be returned.}

\item{identified}{logical; Should identification check for rotational uniqueness a la Millsap (2001) be performed?}

\item{constrain0}{logical; Should variable(s) with all loadings below \code{threshold} still be included in model syntax?
If \code{TRUE}, variable(s) will load onto first factor with the loading constrained to 0.}

\item{ordered}{logical; Should items be treated as ordinal and the
polychoric correlations used in the factor analysis? When \code{FALSE} (default)
the Pearson correlation matrix is used. A character vector of item names is
also accepted to prompt estimation of the polychoric correlation matrix.}

\item{estimator}{if \code{ordered = FALSE}, the default is "ML". If
\code{ordered = TRUE}, the default is "DWLS". See \code{\link[lavaan]{lavaan}} for other options.}

\item{missing}{default is "listwise". See \code{\link[lavaan]{lavaan}} for other options.}

\item{...}{other arguments passed to \code{lavaan} functions. See \code{\link[lavaan]{lavOptions}}.}
}
\value{
A three-element \code{list}:
\itemize{
\item \strong{efas} \code{lavaan} object for each \emph{m} model
\item \strong{loadings} (rotated) factor loading matrix for each \emph{m} model
\item \strong{cfa.syntax} CFA syntax generated from loadings
}
}
\description{
This function is intended for use on independent samples rather than integrated
with k-fold cross-validation.
}
\examples{

# simulate data based on a 3-factor model with standardized loadings
sim.mod <- "f1 =~ .7*x1 + .8*x2 + .3*x3 + .7*x4 + .6*x5 + .8*x6 + .4*x7
                f2 =~ .8*x8 + .7*x9 + .6*x10 + .5*x11 + .5*x12 + .7*x13 + .6*x14
                f3 =~ .6*x15 + .5*x16 + .9*x17 + .4*x18 + .7*x19 + .5*x20
                f1 ~~ .2*f2
                f2 ~~ .2*f3
                f1 ~~ .2*f3
                x9 ~~ .2*x10"
set.seed(1161)
sim.data <- simstandard::sim_standardized(sim.mod, n = 900,
                                          latent = FALSE,
                                          errors = FALSE)[c(2:9,1,10:20)]
# Run 1-, 2-, and 3-factor models
efas <- run_efa(sim.data, m = 3)

}
