% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_embeds.R
\name{fit_embeds_kg}
\alias{fit_embeds_kg}
\title{Fit embeddings to a kgraph object}
\usage{
fit_embeds_kg(
  m_embeds,
  similarity = c("cosine", "inprod", "cov_simi", "norm_inprod"),
  threshold_projs = 0.9,
  df_pairs = NULL,
  df_pairs_cols = 1:2,
  max_concepts = 1000,
  ...
)
}
\arguments{
\item{m_embeds}{Embedding matrix, rownames must be able to be matched to
concepts in df_pairs}

\item{similarity}{Similarity measure to be computed. One of 'inprod' (inner
product), 'cosine', 'cov_simi' (covariance similarity),
'norm_inprod' (normalized inner product).}

\item{threshold_projs}{Specificity threshold to use for projections.
(default 0.9 is equivalent to 10 percent false positives,
and 0.95 to 5 percent false positives)}

\item{df_pairs}{Known relationships data frame}

\item{df_pairs_cols}{Columns of df_pairs for identifiers, that map to
m_embeds rownames}

\item{max_concepts}{Maximum number of concepts to compute all pair-wise
similarities}

\item{...}{Passed to gen_df_notpairs}
}
\value{
Knowledge graph, list of slots df_nodes and df_links
}
\description{
Build a fit_kgraph object to act as an intermediate between the embeddings
and the knowledge graph. If possible (i.e. if number of features is not too
large) compute all pair-wise similarities, otherwise determine the similarity
threshold using a number of random pairs. If a data frame of known pairs is
available, call fit_embeds_to_pairs which will produce an AUC and use the
threshold_projs parameter as the specificity threshold (e.g. the default
specificity of 0.9 corresponds to 10 percent false positives). Otherwise take the
quantile of similarity values corresponding to threshold_projs.
}
