% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_colour_crameri.R
\name{scale_crameri_mutlisequential}
\alias{scale_crameri_mutlisequential}
\title{Fabio Crameri's Multi-Sequential Colour Schemes for \pkg{ggplot2}
and \pkg{ggraph}}
\source{
Crameri, F. (2021). Scientific colour maps. \emph{Zenodo}, v7.0.
\doi{10.5281/zenodo.4491293}
}
\arguments{
\item{...}{Arguments passed to \code{\link[ggplot2:continuous_scale]{ggplot2::continuous_scale()}}.}

\item{reverse}{A \code{\link{logical}} scalar. Should the resulting
vector of colours be reversed?}

\item{range}{A length-two \code{\link{numeric}} vector specifying the
fraction of the scheme's colour domain to keep.}

\item{midpoint}{A length-one \code{\link{numeric}} vector giving the midpoint
(in data value) of the diverging scale. Defaults to \code{0}.}

\item{aesthetics}{A \code{\link{character}} string or vector of character
strings listing the name(s) of the aesthetic(s) that this scale works with.}
}
\value{
A \link[ggplot2:continuous_scale]{continuous} scale.
}
\description{
Provides multi-sequential colour scales from Fabio Crameri's \emph{Scientific
colour}.
}
\details{
Available schemes:
\itemize{
\item \code{oleron}
\item \code{bukavu}
\item \code{fes}
}
}
\section{Interpolation}{

If more colours than defined are needed from a given scheme, the colour
coordinates are linearly interpolated to provide a continuous version of the
scheme.

Note that the default colour for \code{NA} can be overridden by passing
a value to \code{\link[ggplot2:continuous_scale]{ggplot2::continuous_scale()}}.
}

\examples{
data(volcano)

volcan <- data.frame(
  x = rep(1:ncol(volcano), each = nrow(volcano)),
  y = rep(1:nrow(volcano), times = ncol(volcano)),
  z = as.numeric(volcano)
)

ggplot2::ggplot(volcan, ggplot2::aes(x, y, fill = z)) +
  ggplot2::geom_raster() +
  scale_fill_oleron(midpoint = 125)
}
\references{
Crameri, F. (2018). Geodynamic diagnostics, scientific visualisation and
StagLab 3.0. \emph{Geosci. Model Dev.}, 11, 2541-2562.
\doi{10.5194/gmd-11-2541-2018}

Crameri, F., Shephard, G. E. & Heron, P. J. (2020). The misuse of colour in
science communication. \emph{Nature Communications}, 11, 5444.
\doi{10.1038/s41467-020-19160-7}
}
\seealso{
Other colour-blind safe colour schemes: 
\code{\link{scale_crameri_cyclic}},
\code{\link{scale_crameri_diverging}},
\code{\link{scale_crameri_sequential}},
\code{\link{scale_okabeito_discrete}},
\code{\link{scale_tol_discrete}},
\code{\link{scale_tol_diverging}},
\code{\link{scale_tol_sequential}}
}
\author{
N. Frerebeau
}
\concept{colour-blind safe colour schemes}
\keyword{internal}
