% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_colour_crameri.R
\name{scale_crameri_sequential}
\alias{scale_crameri_sequential}
\title{Fabio Crameri's Sequential Colour Schemes for \pkg{ggplot2} and \pkg{ggraph}}
\source{
Crameri, F. (2021). Scientific colour maps. \emph{Zenodo}, v7.0.
\doi{10.5281/zenodo.4491293}
}
\arguments{
\item{...}{Arguments passed to \code{\link[ggplot2:continuous_scale]{ggplot2::continuous_scale()}}.}

\item{reverse}{A \code{\link{logical}} scalar. Should the resulting
vector of colours be reversed?}

\item{range}{A length-two \code{\link{numeric}} vector specifying the
fraction of the scheme's colour domain to keep.}

\item{aesthetics}{A \code{\link{character}} string or vector of character
strings listing the name(s) of the aesthetic(s) that this scale works with.}

\item{discrete}{A \code{\link{logical}} scalar: should the colour scheme be
used as a discrete scale?}
}
\value{
A \link[ggplot2:continuous_scale]{continuous} scale.
}
\description{
Provides sequential colour scales from Fabio Crameri's \emph{Scientific colour}.
}
\details{
Available schemes:
\itemize{
\item \code{batlow}
\item \code{batlowW}
\item \code{batlowK}
\item \code{devon}
\item \code{lajolla}
\item \code{bamako}
\item \code{davos}
\item \code{bilbao}
\item \code{nuuk}
\item \code{oslo}
\item \code{grayC}
\item \code{hawaii}
\item \code{lapaz}
\item \code{tokyo}
\item \code{buda}
\item \code{acton}
\item \code{turku}
\item \code{imola}
}
}
\section{Interpolation}{

If more colours than defined are needed from a given scheme, the colour
coordinates are linearly interpolated to provide a continuous version of the
scheme.

Note that the default colour for \code{NA} can be overridden by passing
a value to \code{\link[ggplot2:continuous_scale]{ggplot2::continuous_scale()}}.
}

\examples{
data(faithfuld, package = "ggplot2")

ggplot2::ggplot(faithfuld, ggplot2::aes(waiting, eruptions, fill = density)) +
  ggplot2::geom_raster() +
  scale_fill_batlow()

ggplot2::ggplot(faithfuld, ggplot2::aes(waiting, eruptions, fill = density)) +
  ggplot2::geom_raster() +
  scale_fill_bamako()

ggplot2::ggplot(faithfuld, ggplot2::aes(waiting, eruptions, fill = density)) +
  ggplot2::geom_raster() +
  scale_fill_hawaii(reverse = TRUE)
}
\references{
Crameri, F. (2018). Geodynamic diagnostics, scientific visualisation and
StagLab 3.0. \emph{Geosci. Model Dev.}, 11, 2541-2562.
\doi{10.5194/gmd-11-2541-2018}

Crameri, F., Shephard, G. E. & Heron, P. J. (2020). The misuse of colour in
science communication. \emph{Nature Communications}, 11, 5444.
\doi{10.1038/s41467-020-19160-7}
}
\seealso{
Other colour-blind safe colour schemes: 
\code{\link{scale_crameri_cyclic}},
\code{\link{scale_crameri_diverging}},
\code{\link{scale_crameri_mutlisequential}},
\code{\link{scale_okabeito_discrete}},
\code{\link{scale_tol_discrete}},
\code{\link{scale_tol_diverging}},
\code{\link{scale_tol_sequential}}
}
\author{
N. Frerebeau
}
\concept{colour-blind safe colour schemes}
\keyword{internal}
