% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/egfr_ckid.R
\name{egfr.ckid_u25.cr}
\alias{egfr.ckid_u25.cr}
\title{Calculate eGFR by CKiD U25 creatinine-based equation (for children and young adults less then 25 years old)}
\usage{
egfr.ckid_u25.cr(
  creatinine,
  age,
  sex,
  height_cm = 0,
  height_ft = 0,
  height_inch = 0,
  creatinine_units = "micromol/l",
  label_sex_male = c("Male", 1),
  label_sex_female = c("Female", 0)
)
}
\arguments{
\item{creatinine}{Numeric vector. Serum creatinine, could be expressed in "micromol/L", "mmol/L" or "mg/dL". Units of measurement should be defined in variable creatinine_units (if not defined explicitly by user, the default value is "micromol/L").}

\item{age}{Numeric vector. Age, in years.}

\item{sex}{Vector. The value of variable refers to the parameters label_sex_male and label_sex_female.}

\item{height_cm}{Numeric vector. Could be defined either as height_cm if is measured in cm, or as height_ft and height_inch if is measured in feet and inches.
If the parameter height_cm is greater than 0, the function uses cm, otherwise - feet and inches.}

\item{height_ft}{see height_cm}

\item{height_inch}{see height_cm}

\item{creatinine_units}{Character string. Units in which serum creatinne is expressed. Could be one of the following: "micromol/L", "mmol/L" or "mg/dL".}

\item{label_sex_male}{List. Label(s) for definition(s) of male sex.}

\item{label_sex_female}{List. Label(s) for definition(s) of female sex.}
}
\value{
numeric eGFR expressed in ml/min/1.73m\ifelse{html}{\out{<sup>2</sup>}}{\eqn{^2}}.
}
\description{
Calculate eGFR by CKiD U25 creatinine-based equation (for children and young adults less then 25 years old)
}
\details{
Calculate estimated glomerular filtration rate (eGFR) by creatinine-based CKiD U25 equation.

Reference to the equation: Pierce CB, Muñoz A, Ng DK, Warady BA, Furth SL, Schwartz GJ. Age- and sex-dependent clinical equations to estimate glomerular filtration rates in children and young adults with chronic kidney disease. Kidney International. 2021;99(4):948–956. doi:10.1016/j.kint.2020.10.047.

Citation: Bikbov B. kidney.epi: Kidney-Related Functions for Clinical and Epidemiological Research. Scientific-Tools.Org, https://Scientific-Tools.Org. DOI: 10.32614/CRAN.package.kidney.epi
}
\examples{
# for a single patient
egfr.ckid_u25.cr (creatinine = 1.4, age = 10, height_cm = 90, sex = "Male",
  creatinine_units = "mg/dl")
# for a dataset - see vignettes for details
# egfr.ckid_u25.cr (creatinine = dta$scr, age = dta$age, height_cm = dta$ht,
#  sex = dta$sex, creatinine_units = "mg/dl")
}
\author{
Programming: Boris Bikbov https://www.linkedin.com/in/boris-bikbov.
}
