% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ckd_classify.R
\name{nephro.proteinuria_category}
\alias{nephro.proteinuria_category}
\title{Calculate proteinuria categories}
\usage{
nephro.proteinuria_category(
  proteinuria,
  proteinuria_units = "mg/g",
  semiquantitative_values = "forbidden"
)
}
\arguments{
\item{proteinuria}{Numeric vector. Urine protein, could be expressed in "mg/day" (24-hour urine collection), "mg/mmol" (UPCR) or "mg/g" (UPCR). Units of measurement should be defined in variable proteinuria_units (if not defined explicitly by user, the default value is "mg/g").}

\item{proteinuria_units}{Character string. Units in which urine protein is measured. Could be one of the following: "mg/day", "mg/mmol" or "mg/g".}

\item{semiquantitative_values}{Character string. Defines whether semiquantitative values are allowed in the data. If "any", all semiquantitative values ('<30', '30-300', '>300') and any numeric values (29, 30, 35, etc) will be classified into A categories (NB! both '30-300' and '30-299' will be classified as A2). If "only_limits", only limiting semiquantitative values ('<30', '>300') will be classified into A categories, but middle semiquantitative values ('30-300') will be omitted; but numeric values (29, 30, 35, etc) will be classified into A categories. If "forbidden", only numeric values will be classified into A categories.}
}
\value{
string albuminuria category.
}
\description{
Calculate proteinuria categories
}
\details{
Calculate albuminuria categories (A1, A2, A3) based on proteinuria values.

Citation: Bikbov B. kidney.epi: Kidney-Related Functions for Clinical and Epidemiological Research. Scientific-Tools.Org, https://Scientific-Tools.Org. DOI: 10.32614/CRAN.package.kidney.epi
}
\examples{
# for a single patient
nephro.proteinuria_category (proteinuria = 25, proteinuria_units = "mg/g")
# for a dataset - see vignettes for details
# nephro.proteinuria_category (proteinuria = dta$alb, proteinuria_units = "mg/g")
}
\author{
Programming: Boris Bikbov https://www.linkedin.com/in/boris-bikbov.
}
