% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_values_in_dt.R
\name{replace_values_in_dt}
\alias{replace_values_in_dt}
\title{Replace values in a data table}
\usage{
replace_values_in_dt(
  data = NULL,
  old_values = NULL,
  new_value = NULL,
  silent = FALSE
)
}
\arguments{
\item{data}{a data object (a data frame or a data.table)}

\item{old_values}{a vector of old values that need to be replaced}

\item{new_value}{a new value that will replace the old values}

\item{silent}{If \code{silent = FALSE}, a message will be printed regarding
how many values were replaced. If \code{silent = TRUE}, no message
will be printed regarding how many values were replaced. (default = FALSE)}
}
\description{
Replace values in a data.table
}
\examples{
replace_values_in_dt(data = mtcars, old_values = c(0, 1), new_value = 999)
replace_values_in_dt(data = mtcars, old_values = 21.0, new_value = 888)
replace_values_in_dt(
data = data.table::data.table(a = NA_character_, b = NA_character_),
old_values = NA, new_value = "")
}
