% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binomial_test.R
\name{binomial_test}
\alias{binomial_test}
\title{Binomial test}
\usage{
binomial_test(
  x = NULL,
  success = NULL,
  failure = NULL,
  p = 0.5,
  alternative = "two.sided",
  ci = 0.95,
  round_percentages = 0
)
}
\arguments{
\item{x}{a vector of values, each of which represents an instance of
either a "success" or "failure" (e.g., c("s", "f", "s", "s", "f", "s"))}

\item{success}{which value(s) indicate "successes"?}

\item{failure}{(optional) which value(s) indicate "failures"?
If no input is provided for this argument, then all the non-NA values
that are not declared to be "successes" will be treated as "failures".}

\item{p}{hypothesized probability of success (default = 0.5)}

\item{alternative}{indicates the alternative hypothesis and must be
one of "two.sided", "greater", or "less". You can specify just the
initial letter. By default, \code{alternative = "two.sided"}}

\item{ci}{width of the confidence interval (default = 0.95)}

\item{round_percentages}{number of decimal places to which to round the
percentages in the summary table (default = 0)}
}
\description{
Conduct a binomial test. In other words, test whether an observed
proportion of "successes" (e.g., proportion of heads in a series
of coin tosses) is greater than the expected proportion (e.g., 0.5).
This function uses the 'binom.test' function from the 'stats' package.
}
\examples{
# sample vector
sample_vector <- c(0, 1, 1, 0, 1, 98, 98, 99, NA)
binomial_test(
x = sample_vector,
success = 1, failure = 0)
binomial_test(
x = sample_vector,
success = 1, failure = 0,
p = 0.1,
alternative = "greater")
binomial_test(
x = sample_vector,
success = c(1, 99), failure = c(0, 98),
p = 0.6,
alternative = "less")
}
