% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlapping_interval.R
\name{overlapping_interval}
\alias{overlapping_interval}
\title{Find the overlapping interval of two ranges.}
\usage{
overlapping_interval(
  interval_1_begin = NULL,
  interval_1_end = NULL,
  interval_2_begin = NULL,
  interval_2_end = NULL
)
}
\arguments{
\item{interval_1_begin}{a number at which the first interval begins
(the left INCLUSIVE endpoint of interval 1)}

\item{interval_1_end}{a number at which the first interval ends
(the right INCLUSIVE endpoint of interval 1)}

\item{interval_2_begin}{a number at which the second interval begins
(the left INCLUSIVE endpoint of interval 2)}

\item{interval_2_end}{a number at which the second interval ends
(the right INCLUSIVE endpoint of interval 2)}
}
\value{
the output will be \code{NULL} if there is no overlapping
region or a vector of the endpoints of the overlapping interval.
}
\description{
This function should be applied to cases where the two ranges are
inclusive of both endpoints. For example, the function can work for
a pair of ranges like [0, 1] and [3, 4] but not for pairs like
[0, 1\) and \(3, 5\)
}
\examples{
overlapping_interval(1, 3, 2, 4)
overlapping_interval(1, 2.22, 2.22, 3)
}
