% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solve_asdp.R
\name{create.solve_asdp}
\alias{create.solve_asdp}
\title{Relaxed optimization for fixed-X and Gaussian knockoffs}
\usage{
create.solve_asdp(Sigma, nBlocks = 10, cores = 1, gaptol = 1e-06,
  maxit = 1000)
}
\arguments{
\item{Sigma}{positive-definite p-by-p covariance matrix.}

\item{nBlocks}{number of blocks in the block-diagonal approximation of Sigma (default: 10).}

\item{cores}{number of cores used to solve the smaller SDPs (default: 1).}

\item{gaptol}{tolerance for duality gap as a fraction of the value of the objective functions (default: 1e-6).}

\item{maxit}{the maximum number of iterations for the solver (default: 1000).}
}
\value{
The solution \eqn{s} to the semidefinite programming problem defined above.
}
\description{
This function solves the optimization problem needed to create fixed-X and Gaussian SDP knockoffs
on a block-diagonal approximation of the covariance matrix. This will be less
powerful than \code{\link{create.solve_sdp}}, but more computationally efficient.
}
\details{
Solves the following two-step semidefinite programming problem:

  (step 1)  \deqn{ \mathrm{maximize}     \; \mathrm{sum}(s) \quad
                   \mathrm{subject} \; \mathrm{to:}  \; 0 \leq s \leq 1, \;
                                         2 \Sigma_{\mathrm{approx}} - \mathrm{diag}(s) \geq 0}
                             
  (step 2) \deqn{ \mathrm{maximize}      \; \gamma \quad
                  \mathrm{subject} \; \mathrm{to:}    \; \mathrm{diag}(\gamma s) \leq 2 \Sigma}

Each smaller SDP is solved using the interior-point method implemented in \code{\link[Rdsdp]{dsdp}}.

If the matrix Sigma supplied by the user is a non-scaled covariance matrix 
(i.e. its diagonal entries are not all equal to 1), then the appropriate scaling is applied before
solving the SDP defined above. The result is then scaled back before being returned, as to match 
the original scaling of the covariance matrix supplied by the user.
}
\seealso{
Other optimization: \code{\link{create.solve_equi}},
  \code{\link{create.solve_sdp}}
}
