# Copyright 2010-2014 Meik Michalke <meik.michalke@hhu.de>
#
# This file is part of the R package koRpus.
#
# koRpus is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# koRpus is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with koRpus.  If not, see <http://www.gnu.org/licenses/>.


#' Getter/setter methods for koRpus objects
#' 
#' These methods should be used to get or set values of tagged text objects
#' generated by koRpus functions like \code{treetag()} or \code{tokenize()}.
#' 
#' \itemize{
#'   \item{\code{taggedText()} }{returns the \code{TT.res} slot.}
#'   \item{\code{describe()} }{returns the \code{desc} slot.}
#'   \item{\code{language()} }{returns the \code{lang} slot.}
#'   \item{\code{hyphenText()} }{returns the \code{hyphen} slot from objects of class \code{kRp.hyphen}.}
#' }
#' @rdname kRp.taggedText-methods
#' @docType methods
#' @export
#' @examples
#' \dontrun{
#' taggedText(tagged.txt)
#' }
setGeneric("taggedText", function(obj) standardGeneric("taggedText"))
#' @rdname kRp.taggedText-methods
#' @export
#' @docType methods
#' @aliases
#'    taggedText,-methods
#'    taggedText,kRp.taggedText-method
#' @include koRpus-internal.R
setMethod("taggedText",
  signature=signature(obj="kRp.taggedText"),
  function (obj){
    result <- slot(obj, name="TT.res")
    return(result)
  }
)

#' @rdname kRp.taggedText-methods
#' @export
#' @docType methods
#' @param value The new value to replace the current with.
setGeneric("taggedText<-", function(obj, value) standardGeneric("taggedText<-"))
#' @rdname kRp.taggedText-methods
#' @export
#' @docType methods
#' @aliases
#'    taggedText<-,-methods
#'    taggedText<-,kRp.taggedText-method
#' @include koRpus-internal.R
setMethod("taggedText<-",
  signature=signature(obj="kRp.taggedText"),
  function (obj, value){
    slot(obj, name="TT.res") <- value
    return(obj)
  }
)


#' @export
#' @docType methods
#' @rdname kRp.taggedText-methods
setGeneric("describe", function(obj) standardGeneric("describe"))
#' @rdname kRp.taggedText-methods
#' @export
#' @docType methods
#' @aliases
#'    describe,-methods
#'    describe,kRp.taggedText-method
#' @include koRpus-internal.R
setMethod("describe",
  signature=signature(obj="kRp.taggedText"),
  function (obj){
    result <- slot(obj, name="desc")
    return(result)
  }
)

#' @rdname kRp.taggedText-methods
#' @export
#' @docType methods
setGeneric("describe<-", function(obj, value) standardGeneric("describe<-"))
#' @rdname kRp.taggedText-methods
#' @export
#' @docType methods
#' @aliases
#'    describe<-,-methods
#'    describe<-,kRp.taggedText-method
#' @include koRpus-internal.R
setMethod("describe<-",
  signature=signature(obj="kRp.taggedText"),
  function (obj, value){
    slot(obj, name="desc") <- value
    return(obj)
  }
)

#' @rdname kRp.taggedText-methods
#' @export
#' @docType methods
#' @aliases
#'    describe,kRp.hyphen-method
#' @include 00_class_08_kRp.hyphen.R
setMethod("describe",
  signature=signature(obj="kRp.hyphen"),
  function (obj){
    result <- slot(obj, name="desc")
    return(result)
  }
)

#' @rdname kRp.taggedText-methods
#' @export
#' @docType methods
#' @aliases
#'    describe<-,kRp.hyphen-method
#' @include 00_class_08_kRp.hyphen.R
setMethod("describe<-",
  signature=signature(obj="kRp.hyphen"),
  function (obj, value){
    slot(obj, name="desc") <- value
    return(obj)
  }
)

#' @export
#' @docType methods
#' @rdname kRp.taggedText-methods
setGeneric("language", function(obj) standardGeneric("language"))
#' @rdname kRp.taggedText-methods
#' @export
#' @docType methods
#' @aliases
#'    language,-methods
#'    language,kRp.taggedText-method
#' @include koRpus-internal.R
setMethod("language",
  signature=signature(obj="kRp.taggedText"),
  function (obj){
    result <- slot(obj, name="lang")
    return(result)
  }
)

#' @rdname kRp.taggedText-methods
#' @export
#' @docType methods
setGeneric("language<-", function(obj, value) standardGeneric("language<-"))
#' @rdname kRp.taggedText-methods
#' @export
#' @docType methods
#' @aliases
#'    language<-,-methods
#'    language<-,kRp.taggedText-method
#' @include koRpus-internal.R
setMethod("language<-",
  signature=signature(obj="kRp.taggedText"),
  function (obj, value){
    slot(obj, name="lang") <- value
    return(obj)
  }
)

#' @rdname kRp.taggedText-methods
#' @export
#' @docType methods
#' @aliases
#'    language,kRp.hyphen-method
#' @include 00_class_08_kRp.hyphen.R
setMethod("language",
  signature=signature(obj="kRp.hyphen"),
  function (obj){
    result <- slot(obj, name="lang")
    return(result)
  }
)

#' @rdname kRp.taggedText-methods
#' @export
#' @docType methods
#' @aliases
#'    language<-,kRp.hyphen-method
#' @include 00_class_08_kRp.hyphen.R
setMethod("language<-",
  signature=signature(obj="kRp.hyphen"),
  function (obj, value){
    slot(obj, name="lang") <- value
    return(obj)
  }
)

#' @param obj An arbitrary \code{R} object.
#' @rdname kRp.taggedText-methods
#' @export
is.taggedText <- function(obj){
  inherits(obj, "kRp.taggedText")
}

#' @export
#' @docType methods
#' @rdname kRp.taggedText-methods
setGeneric("hyphenText", function(obj) standardGeneric("hyphenText"))
#' @rdname kRp.taggedText-methods
#' @export
#' @docType methods
#' @aliases
#'    hyphenText,-methods
#'    hyphenText,kRp.hyphen-method
#' @include 00_class_08_kRp.hyphen.R
setMethod("hyphenText",
  signature=signature(obj="kRp.hyphen"),
  function (obj){
    result <- slot(obj, name="hyphen")
    return(result)
  }
)

#' @rdname kRp.taggedText-methods
#' @export
#' @docType methods
setGeneric("hyphenText<-", function(obj, value) standardGeneric("hyphenText<-"))
#' @rdname kRp.taggedText-methods
#' @export
#' @docType methods
#' @aliases
#'    hyphenText<-,-methods
#'    hyphenText<-,kRp.hyphen-method
#' @include 00_class_08_kRp.hyphen.R
setMethod("hyphenText<-",
  signature=signature(obj="kRp.hyphen"),
  function (obj, value){
    slot(obj, name="hyphen") <- value
    return(obj)
  }
)
