% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_method_kRp.taggedText.R
\docType{methods}
\name{taggedText}
\alias{taggedText}
\alias{taggedText,kRp.taggedText-method}
\alias{taggedText,-methods}
\alias{taggedText<-}
\alias{taggedText<-,kRp.taggedText-method}
\alias{taggedText<-,-methods}
\alias{[,kRp.taggedText-method}
\alias{[,-methods}
\alias{[,kRp.taggedText,ANY,ANY-method}
\alias{[<-,kRp.taggedText-method}
\alias{[<-,-methods}
\alias{[<-,kRp.taggedText,ANY,ANY,ANY-method}
\alias{[[,kRp.taggedText-method}
\alias{[[,-methods}
\alias{[[,kRp.taggedText,ANY-method}
\alias{[[<-,kRp.taggedText-method}
\alias{[[<-,-methods}
\alias{[[<-,kRp.taggedText,ANY,ANY-method}
\alias{describe,kRp.taggedText-method}
\alias{describe,-methods}
\alias{describe<-,kRp.taggedText-method}
\alias{describe<-,-methods}
\alias{language,kRp.taggedText-method}
\alias{language,-methods}
\alias{language<-,kRp.taggedText-method}
\alias{language<-,-methods}
\alias{is.taggedText}
\alias{fixObject}
\alias{fixObject,kRp.taggedText-method}
\alias{fixObject,-methods}
\alias{tif_as_tokens_df}
\alias{tif_as_tokens_df,kRp.taggedText-method}
\alias{tif_as_tokens_df,-methods}
\title{Getter/setter methods for koRpus objects}
\usage{
taggedText(obj, add.desc = FALSE, doc_id = FALSE)

\S4method{taggedText}{kRp.taggedText}(obj, add.desc = FALSE,
  doc_id = FALSE)

taggedText(obj) <- value

\S4method{taggedText}{kRp.taggedText}(obj) <- value

\S4method{[}{kRp.taggedText}(x, i, j)

\S4method{[}{kRp.taggedText}(x, i, j) <- value

\S4method{[[}{kRp.taggedText}(x, i)

\S4method{[[}{kRp.taggedText}(x, i) <- value

\S4method{describe}{kRp.taggedText}(obj)

\S4method{describe}{kRp.taggedText}(obj) <- value

\S4method{language}{kRp.taggedText}(obj)

\S4method{language}{kRp.taggedText}(obj) <- value

is.taggedText(obj)

fixObject(obj, doc_id = NA)

\S4method{fixObject}{kRp.taggedText}(obj, doc_id = NA)

tif_as_tokens_df(tokens)

\S4method{tif_as_tokens_df}{kRp.taggedText}(tokens)
}
\arguments{
\item{obj}{An arbitrary \code{R} object.}

\item{add.desc}{Logical,
      determines whether the \code{desc} column should be re-written with descriptions
for all POS tags.}

\item{doc_id}{Logical (except for \code{fixObject}),
      if \code{TRUE} the \code{doc_id} column will be a factor with the respective value
of the \code{desc} slot, i.\,e.,
      the document ID will be preserved in the data.frame. If used with \code{fixObject}, can be a character string
to set the document ID manually (the default \code{NA} will preserve existing values and not overwrite them).}

\item{value}{The new value to replace the current with.}

\item{x}{An object of class \code{kRp.taggedText} or \code{kRp.hyphen}.}

\item{i}{Defines the row selector (\code{[}) or the name to match (\code{[[}).}

\item{j}{Defines the column selector.}

\item{tokens}{An object of class \code{\link[koRpus:kRp.tagged-class]{kRp.tagged}}.}
}
\description{
These methods should be used to get or set values of tagged text objects
generated by koRpus functions like \code{treetag()} or \code{tokenize()}.
}
\details{
\itemize{
  \item{\code{taggedText()} }{returns the \code{TT.res} slot.}
  \item{\code{describe()} }{returns the \code{desc} slot.}
  \item{\code{language()} }{returns the \code{lang} slot.}
  \item{\code{[}/\code{[[} }{Can be used as a shortcut to index the results of \code{taggedText()}.}
  \item{\code{fixObject} }{returns the same object upgraded to the object structure of this package version (e.g.,
      new columns, changed names, etc.).}
  \item{\code{tif_as_tokens_df} }{returns the \code{TT.res} slot in a TIF[1] compliant format,
      i.e., \code{doc_id} is not a factor but a character vector.}
}
}
\examples{
\dontrun{
taggedText(tagged.txt)
}
}
\references{
[1] Text Interchange Formats (\url{https://github.com/ropensci/tif})
}
