% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmsassess.R
\name{kmsassess}
\alias{kmsassess}
\title{Perform a simplified probabilistic knowledge assessment}
\usage{
kmsassess(r, ks, questioning, update, beta, eta, zeta0, zeta1, threshold)
}
\arguments{
\item{r}{Response pattern (binary vector)}

\item{ks}{Knowledge structure: a binary matrix}

\item{questioning}{Questioning rule ("halfsplit" o "informative")}

\item{update}{Update rule ("Bayesian" or "multiplicative")}

\item{beta}{Careless error probability}

\item{eta}{Lucky guess probability}

\item{zeta0}{Update parameter for wrong responses}

\item{zeta1}{Update parameter for correct responses}

\item{threshold}{Probability threshold for stopping criterion}
}
\value{
A list with the following elements:
\describe{
\item{state}{Diagnosed knowledge state (binary vector)}
\item{probs}{Resultng probability distribution}
\item{queried}{Sequence of items used in the assessment (list)}
}
}
\description{
\code{kmsassess} performs a simplified probabilistic knowledge assessment
for a given response vector, knowledge structure, and BLIM parameters. It
assumes an equal probability distribution over the knowledge structure
as starting point and identical beta and eta values for all items.
}
\details{
\code{kmsassess} uses the \code{kmassess} function, so the explanations there hold also here.
}
\examples{
kmsassess(c(1,1,0,0), xpl$space, "halfsplit", "Bayesian", 0.3, 0.2, NULL, NULL, 0.55)

}
\seealso{
Other Knowledge assessment: 
\code{\link{kmassess}()},
\code{\link{kmassessbayesian}()},
\code{\link{kmassesshalfsplit}()},
\code{\link{kmassessinformative}()},
\code{\link{kmassessmentsimulation}()},
\code{\link{kmassessmultiplicative}()}
}
\concept{Knowledge assessment}
