% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{dts}
\alias{dts}
\title{Delete trailing slash}
\usage{
dts(name)
}
\arguments{
\item{name}{A path}
}
\value{
Same path with trailing "/" removed.
}
\description{
This function cleans up a path string by removing the trailing
slash.  This is necessary on MS Windows, \code{file.exists(fn)} fails
if "/" is on end of file name. Deleting the trailing slash is thus
required on Windows and it is not harmful on other platforms.
}
\details{
All usages of \code{file.exists(fn)} in R should be revised
to be multi-platform safe by writing \code{file.exists(dts(fn))}.

This version also removes repeated adjacent slashes, so that
\code{"/tmp///paul//test/"} becomes \code{"/tmp/paul/test"}.
}
\author{
Paul Johnson <pauljohn@ku.edu>
}

