% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project.R
\name{initProject}
\alias{initProject}
\title{Create project directories, initialize a git repo, create README.md
ChangeLog, and R template file in R directory}
\usage{
initProject(dir = NULL, ddir = "data", wdir = "workingdata",
  odir = "output", tdir = "tmp", ldir = "lit", writedir = "writeup",
  rdir = "R", ..., gitArgs = "--shared=group")
}
\arguments{
\item{dir}{Default NULL, otherwise a legal directory name to serve
as the top level directory for this project}

\item{ddir}{Data directory, place where "read only" unadjusted
data files are kept. Default is "data". If user sets it as NA
or NULL, the directory will not be created.}

\item{wdir}{Working data directory, where recorded, revised, and
cleaned data files are kept. Default is "workingdata".}

\item{odir}{Output directory. Default is "output".}

\item{tdir}{Temporary directory, where trash files can be kept for
safe keeping. Default is "tmp".}

\item{ldir}{Literature directory, where material about the project
can be stored. Default is "lit".}

\item{writedir}{The folder where the project writeup will be
stored. Default is "writeup".}

\item{rdir}{The name to be used for the R files. Defaults to "R".}

\item{...}{A list of other directories that the user would like to
create. For example, \code{adir = "admin"}, \code{cdir =
"client_provided"}, \code{bdir = "codebooks"}, \code{sdir =
"Stata"}, \code{mdir = "Mplus"}. These may be grouped in a
named vector or list, if user convenience dictates.}

\item{gitArgs}{This function tries to run "git init" and in our
center we add "--shared=group" on a network file server. If
that is undesirable in a user's context, put the argument
gitArgs as "".}
}
\value{
Name of project top level directory. Leaves the R
    working directory unchanged.
}
\description{
This creates folders for the separate parts of a project. It tries
to be clever about which directories are created and where they are
placed. Please see details for 3 scenarios for which we have
planned. If a directory already exists, it will not be damaged or
re-created.
}
\details{
If the dir argument is NULL, as default, then the current working
directory will be the place where new directories and the git
repository will be created.  Assuming the current working
directory's base name is not "R", then folders named "R", "data",
and so forth will be created in the current working directory.

If one has a current R working directory with a basename "R"
(suppose it is \code{"/tmp/whatever/R"}), and the user runs
\code{initProject()}, something different happens. The function
assumes we don't want to create subdirectories inside R. We don't
want to end up with \code{"/tmp/whatever/R/R"}. We don't
want \code{"/tmp/whatever/R/data"} either.  Instead, it assumes we
want the new directories created on same level as R, so it creates
\code{"/tmp/whatever/data"}, \code{"/tmp/whatever/workingdata"},
and so forth.  From within the R directory, these new directories
are seen as \code{"../data"}, \code{"../workingdata"}, and so
forth. That is, we should end up with directories and a git repo
in \code{"/tmp/whatever"}.

If the \code{dir} argument is provided by the user, then that is
used as the folder in which directories \code{"R"}, \code{"data"},
\code{"workingdate"}, and so forth are created.  All materials are
created in \code{dir}, no matter what the current working
directory is named (even if it is \code{"R"}).

The examples demonstrate all three of these scenarios.
}
\examples{
tempdir <- tempdir()
setwd(tempdir)
dir.create("test0")
setwd("test0")
initProject()
list.files(all.files = TRUE)
setwd(tempdir)
dir.create("test1")
setwd("test1")
## demonstrate ability to create other directories
initProject(admin = "admin", clientfiles = "client")
list.files(all.files = TRUE)
setwd(tempdir)
dir.create("test2/R", recursive = TRUE)
setwd("test2/R")
initProject(adir = "accounting")
list.files(all.files = TRUE)
list.files("../", all.files = TRUE)
setwd(tempdir)
initProject("test3")
list.files("test3", all.files = TRUE)
setwd(tempdir)
## demonstrate ability to create other directories
initProject(file.path(tempdir, "test4"),
            list(mdir = "Mplus", sasdir = "SAS"))
list.files(file.path(tempdir, "test4"), all.files = TRUE)
setwd(tempdir)
## demonstrate ability to nullify standard directories
initProject("test5", odir = NA, tdir = NA, writedir = NA)
list.files("test5", all.files = TRUE)
unlink(c("test1", "test2", "test3", "test4", "test5"), recursive = TRUE)
}
\author{
Paul Johnson <pauljohn@ku.edu>
}
