% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtwv.R
\name{getwave}
\alias{a2d}
\alias{agrid}
\alias{df2mt}
\alias{getwave}
\title{Internal Function For Directional KZ Periodogram \code{kzpdr}}
\usage{
getwave(df, angle)

a2d(a)

df2mt(df, scale)

agrid(df, scale, math = "mean")
}
\arguments{
\item{df}{Data frame of signal values and positions.}

\item{angle}{Direction or vector of directions in radians.}

\item{a}{2D array for position and signal values.}

\item{scale}{Vector for scale of each dimension. For example,
for a \emph{x * y} grid, the scale is \emph{c(1/x, 1/y)}.}

\item{math}{Function to aggregate the data. Defaults to "mean".}
}
\description{
A group of internal functions used by \code{kzpdr} function.
\itemize{
  \item \code{getaway} is designed to extract data series along 
a given line in a 2D field.

  \item \code{agrid} is to aggregate data based on given grid points.

  \item \code{a2d} transfers 2D array to data frame. If input is data frame, 
it will return the original data frame.

  \item \code{df2mt} transfers data frame to matrix.
}
}
\keyword{internal}

