% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recode.R
\name{recode.labelled}
\alias{recode.labelled}
\title{Recode values}
\usage{
\method{recode}{labelled}(.x, ..., .default = NULL, .missing = NULL)
}
\arguments{
\item{.x}{A vector to modify}

\item{...}{Replacements. These should be named for character and factor
\code{.x}, and can be named for numeric \code{.x}. The argument names should be the
current values to be replaced, and the argument values should be the new
(replacement) values.

All replacements must be the same type, and must have either
length one or the same length as x.

These dots are evaluated with \link[rlang:dots_list]{explicit splicing}.}

\item{.default}{If supplied, all values not otherwise matched will
be given this value. If not supplied and if the replacements are
the same type as the original values in \code{.x}, unmatched
values are not changed. If not supplied and if the replacements
are not compatible, unmatched values are replaced with \code{NA}.

\code{.default} must be either length 1 or the same length as
\code{.x}.}

\item{.missing}{If supplied, any missing values in \code{.x} will be
replaced by this value. Must be either length 1 or the same length as
\code{.x}.}
}
\description{
Extend \code{\link[dplyr]{recode}} method from \pkg{haven} to
works with labelled vectors.
}
\examples{
x <- labelled(1:3, c(yes = 1, no = 2))
x
dplyr::recode(x, `3` = 2L)
}
\seealso{
\code{\link[dplyr]{recode}} (\pkg{dplyr})
}
