% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleansing_corpus.R
\name{cleansing_corpus}
\alias{cleansing_corpus}
\title{Cleansing Corpus}
\usage{
cleansing_corpus(
  text,
  escape_chars = TRUE,
  nonalphanum = TRUE,
  longwords = TRUE,
  whitespace = TRUE,
  tolower = TRUE
)
}
\arguments{
\item{text}{Character vector of free text to be cleansed.}

\item{escape_chars}{If TRUE, removes escape characters for \verb{slash n}, \verb{slash r} and \verb{slash t}.}

\item{nonalphanum}{If TRUE, removes non-alphanumeric characters.}

\item{longwords}{If TRUE, removes words with more than 35 characters.}

\item{whitespace}{If TRUE, removes excess whitespace.}

\item{tolower}{If TRUE, turns letters to lower.}
}
\value{
A character vector of the cleansed text.
}
\description{
The function performs text cleansing by removing escape characters, non alphanumeric,
long-words, excess space, and turns all letters to lower case.
}
\examples{
txt <- "It has roots in a piece of classical Latin literature from 45 BC"
cleansing_corpus(txt)
}
