% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error-handling.R
\name{stop_decomposition}
\alias{stop_decomposition}
\alias{handle_decomposition_error}
\title{Raise an error with a request ID if known}
\usage{
stop_decomposition(..., request_id = NULL)

handle_decomposition_error(config)
}
\arguments{
\item{...}{zero or more objects which can be coerced to character (and which
are pasted together with no separator). This forms the error message.}

\item{request_id}{character. Used in error handling during event
decomposition, when it's possible that a request ID might be known but the
event hasn't been fully examined yet.}
}
\description{
During decomposition from an invocation into an event, it is possible for an
error to occur when a request ID is known but the event hasn't been fully
realised yet. In order to handle these, an error must be posted to the
invocation error endpoint.

\code{stop_decomposition} raises an error with an optional \code{request_id}. The error
can then be processed by \code{handle_decomposition_error}. If a \code{request_id} is
present then the error can be posted to the invocation error endpoint.
Otherwise, the error is simply logged. In either case the error does not
stop the kernel, and the runtime can move onto the next event.

\code{handle_decomposition_error} accepts a \code{config} object, created through the
\code{\link{lambda_config}} function. It returns a function that accepts an
error \code{e}, which means that \code{handle_decomposition_error(event)} can be passed
as a value to the \code{tryCatch} \code{error} argument.
}
\keyword{internal}
