% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HLIRdynamics.R
\name{HLIRdynamics}
\alias{HLIRdynamics}
\title{Generation of model outputs}
\usage{
HLIRdynamics(pathRES, graphOn, times, landscape, hostP, epiP, evolP,
  th_break = 50000, nMapPY = 0)
}
\arguments{
\item{pathRES}{a character string indicating the path of the repository where outputs will be generated.}

\item{graphOn}{a logical indicating if graphics of the outputs must be generated (1) or not (0).}

\item{times}{a list of simulation parameters (number of years, number of time-steps per year).}

\item{landscape}{a shapefile containing the agricultural landscape (can be generated through function AgriLand).}

\item{hostP}{a list of host parameters (number of cultivars, growth rate of the susceptible cultivar, reproduction rate of the susceptible cultivar, 
growth rate of resistant cultivars, reproduction rate of resistant cultivars, death rate, number of possible resistance sources (8)
, resistance formula, parameters of the sigmoid invasion function: kappa, sigma and s).}

\item{epiP}{a list of pathogen parameters (probability to survive the off-season, infection rate
, reproduction rate, average latent period duration, variance of the latent period, average infectious period duration
, variance of the infectious period duration, parameters of the sigmoid contamination function: kappa, sigma, s).}

\item{evolP}{a list of evolution parameters (cost of infectivity, cost of aggressiveness, mutation rate, efficiency of major 
resistance genes, efficiency of quantitative resistance, trade-off strength, number of increments of quantitative 
resistance erosion, adaptation formula).}

\item{th_break}{an integer giving the threshold (number of infections) above which mutant pathogen are unlikely to go extinct, used to 
characterise resistance breakdown.}

\item{nMapPY}{an integer specifying the number of epidemic maps per year to generate.}
}
\value{
A set of text files containing all outputs of the simulations (see details). 
A set of graphics and epidemic maps can also be generated.
}
\description{
Generate epidemiological and evolutionary outputs from model simulations.
}
\details{
\describe{
\item{\strong{Evolutionary outputs.}}{ \describe{
\item{\emph{Durability of qualitative resistance:}}{
For a given major gene, several computations are 
performed: \itemize{
\item (d1) time to first appearance of a pathogen mutant;
\item (d2) time to first true infection of a resistant host by such mutants; and 
\item (d3) time when the number of infections of resistant hosts by these mutants reaches a threshold above which mutant pathogens are unlikely to go extinct.
} 
}
\item{\emph{Erosion of quantitative resistance:}}{
pathogen adaptation to quantitative resistance is gradual, so the three measures described above are computed for every step 
towards complete erosion of resistance (i.e. nAgw-1 levels).} 
\item{\emph{Durability of a deployment strategy:}}{ a simulation run is divided into three periods: \enumerate{
\item the initial short-term period when all resistance sources are at their highest potential; 
\item a transitory period during which a given deployment strategy is only partially effective; and 
\item a longer-term period when all the resistances have been overcome or completely eroded. 
}
To assess the end of the short-term period, the time to establishment (durability measure (d3)) is computed for every major gene, and every quantitative trait 
at the first level of erosion (agw(p)=2). The minimal value of these measures, denoted by D1, delimitates short-term and transitory periods. 
Similarly, the time to establishment is computed for every major gene, and for every quantitative trait at the highest level of erosion (agw(p)=nAgw). 
The maximal value of these measures, termed D2, delimits transitory and long-term periods.
}
}
}
\item{\strong{Epidemiological outputs.}}{ 
The epidemiological impact of pathogen spread is evaluated by two different measures: \enumerate{
\item Green Leaf Area (GLA): The GLA represents the average number of productive hosts per time step and per surface unit.
\item Area Under Disease Progress Curve (AUDPC): The AUDPC is the average proportion of diseased hosts relative to the carrying capacity and represents disease severity.
}
\describe{
\item{\emph{Global epidemiological control:}}{
The GLA and AUDPC of every cultivar as well as the whole landscape are averaged across the whole simulation run, 
 to measure the global epidemiological performance of a deployment strategy.} 
 \item{\emph{Short-term epidemiological control:}}{
  The average GLA and AUDPC of the susceptible 
 cultivar is computed on whole cropping seasons from the beginning of the simulation until the end of 
 the season preceding year before D1.}
 \item{\emph{Epidemiological control during the transitory period:}}{
 The average GLA and AUDPC of the susceptible cultivar is computed on whole seasons from the 
 beginning of the season following year after D1 to the end of the season year before preceding D2.} 
 \item{\emph{Long-term epidemiological control:}}{
 The average GLA and AUDPC of the whole landscape is computed on whole seasons 
 from the beginning of the year after D2 to the end of the simulation.}
 }
 }
 }
}
\examples{
\donttest{
demo_landsepi()
}
}
\references{
Rimbaud L., Papaïx J., Rey J.-F., Barrett L. G. and Thrall P. H. (2018). Assessing the durability and efficiency of landscape-based strategies to deploy plant resistance to pathogens. \emph{PLoS Computational Biology} 14(4):e1006067.
}
