% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusters.R
\name{clusterOptimalK}
\alias{clusterOptimalK}
\title{Visualize K-Means Clusters for Several K Methods}
\usage{
clusterOptimalK(
  df,
  method = c("wss", "silhouette", "gap_stat"),
  drop_na = TRUE,
  ohse = TRUE,
  norm = TRUE,
  quiet = TRUE,
  ...
)
}
\arguments{
\item{df}{Dataframe}

\item{method}{Character vector.}

\item{drop_na}{Boolean. Should NA rows be removed?}

\item{ohse}{Boolean. Do you wish to automatically run one hot
encoding to non-numerical columns?}

\item{norm}{Boolean. Should the data be normalized?}

\item{quiet}{Boolean. Keep quiet? If not, print messages.}

\item{...}{Additional parameters passed to \code{factoextra::fviz_nbclust}}
}
\value{
Plot. Optimal number of clusters of \code{df} data.frame given a
selected \code{method}.
}
\description{
Visualize cluster data for assorted values of k and methods such as
WSS, Silhouette and Gap Statistic. See \code{factoextra::fviz_nbclust} 
for more.
}
\examples{
# You must have \code{factoextra} library to use this auxiliary function:
\dontrun{
data("iris")
df <- subset(iris, select = c(-Species))
# Calculate and plot optimal k clusters
clusterOptimalK(df)
}
}
\seealso{
Other Clusters: 
\code{\link{clusterKmeans}()},
\code{\link{clusterVisualK}()}
}
\concept{Clusters}
