% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/currency.R
\name{get_currency}
\alias{get_currency}
\title{Download Historical Currency Exchange Rate}
\usage{
get_currency(
  currency_pair,
  from = Sys.Date() - 99,
  to = Sys.Date(),
  fill = FALSE
)
}
\arguments{
\item{currency_pair}{Character. Which currency exchange do you
wish to get the history from? i.e, USD/COP, EUR/USD...}

\item{from}{Date. From date}

\item{to}{Date. To date}

\item{fill}{Boolean. Fill weekends and non-quoted dates with 
previous values?}
}
\value{
data.frame. Result of fetching online data for \code{currency_pair}
grouped by date.
}
\description{
This function lets the user download historical currency exchange
rate between two currencies.
}
\examples{
\donttest{
# For today (or any one single date)
get_currency("USD/COP", from = Sys.Date())
# For multiple dates
get_currency("EUR/USD", from = Sys.Date() - 7, fill = TRUE)
}
}
\concept{Currency}
