% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_functions.R
\name{ip_data}
\alias{ip_data}
\title{Scrap data based on IP address}
\usage{
ip_data(ip = myip(), quiet = FALSE)
}
\arguments{
\item{ip}{Vector. Vector with all IP's we wish to search.}

\item{quiet}{Boolean. Do not show the loading \code{statusbar}?}
}
\value{
data.frame. Each row is an unique \code{ip} address,
and columns will bee created for all the additional information found.
}
\description{
This function lets the user scrap https://db-ip.com/ given
IP address(es) to get their associated address type, ASN, ISP,
organization, country, state or region, county, city, ZIP postal code,
weather station, coordinates, Timezone, local time, languages, and currency.
}
\examples{
\donttest{
ip_data("163.114.132.0")
ip_data(ip = c(myip(), "201.244.197.199"), quiet = TRUE)
}
}
\seealso{
Other Tools: 
\code{\link{autoline}()},
\code{\link{bindfiles}()},
\code{\link{bring_api}()},
\code{\link{db_download}()},
\code{\link{db_upload}()},
\code{\link{export_plot}()},
\code{\link{export_results}()},
\code{\link{get_credentials}()},
\code{\link{h2o_predict_API}()},
\code{\link{h2o_predict_MOJO}()},
\code{\link{h2o_predict_binary}()},
\code{\link{h2o_predict_model}()},
\code{\link{h2o_selectmodel}()},
\code{\link{haveInternet}()},
\code{\link{image_metadata}()},
\code{\link{importxlsx}()},
\code{\link{json2vector}()},
\code{\link{listfiles}()},
\code{\link{mailSend}()},
\code{\link{msplit}()},
\code{\link{myip}()},
\code{\link{quiet}()},
\code{\link{read.file}()},
\code{\link{statusbar}()},
\code{\link{tic}()},
\code{\link{try_require}()},
\code{\link{updateLares}()},
\code{\link{zerovar}()}

Other Scrapper: 
\code{\link{filesGD}()},
\code{\link{get_mp3}()},
\code{\link{holidays}()},
\code{\link{readGS}()},
\code{\link{splot_etf}()},
\code{\link{stocks_hist}()},
\code{\link{stocks_quote}()},
\code{\link{trendsRelated}()},
\code{\link{writeGS}()}
}
\concept{Scrapper}
\concept{Tools}
