% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequencies.R
\name{freqs_df}
\alias{freqs_df}
\title{Plot for All Frequencies on Dataframe}
\usage{
freqs_df(
  df,
  max = 0.9,
  min = 0,
  novar = TRUE,
  plot = FALSE,
  top = 30,
  quiet = FALSE,
  save = FALSE,
  subdir = NA
)
}
\arguments{
\item{df}{Data.frame}

\item{max}{Numeric. Top variance threshold. Range: (0-1].
These variables will be excluded}

\item{min}{Numeric. Minimum variance threshold. Range: [0-1).
These values will be grouped into a high frequency (HF) value}

\item{novar}{Boolean. Remove no variance columns?}

\item{plot}{Boolean. Do you want to see a plot? Three variables tops}

\item{top}{Integer. Plot most relevant (less categories) variables}

\item{quiet}{Boolean. Keep quiet? (or show variables exclusions)}

\item{save}{Boolean. Save the output plot in our working directory}

\item{subdir}{Character. Into which subdirectory do you wish to
save the plot to?}
}
\value{
Plot when \code{plot=TRUE} and data.frame with grouped frequency results
when \code{plot=FALSE}.
}
\description{
This function lets the user analize data by visualizing the
frequency of each value of each column from a whole data frame.
}
\examples{
\donttest{
data(dft) # Titanic dataset
freqs_df(dft)
freqs_df(dft, plot = TRUE)
}
}
\seealso{
Other Frequency: 
\code{\link{freqs_list}()},
\code{\link{freqs_plot}()},
\code{\link{freqs}()}

Other Exploratory: 
\code{\link{corr_cross}()},
\code{\link{corr_var}()},
\code{\link{crosstab}()},
\code{\link{df_str}()},
\code{\link{distr}()},
\code{\link{freqs_list}()},
\code{\link{freqs_plot}()},
\code{\link{freqs}()},
\code{\link{lasso_vars}()},
\code{\link{missingness}()},
\code{\link{plot_cats}()},
\code{\link{plot_df}()},
\code{\link{plot_nums}()},
\code{\link{tree_var}()},
\code{\link{trendsRelated}()}

Other Visualization: 
\code{\link{distr}()},
\code{\link{freqs_list}()},
\code{\link{freqs_plot}()},
\code{\link{freqs}()},
\code{\link{noPlot}()},
\code{\link{plot_chord}()},
\code{\link{plot_survey}()},
\code{\link{plot_timeline}()},
\code{\link{tree_var}()}
}
\concept{Exploratory}
\concept{Frequency}
\concept{Visualization}
