% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrangling.R
\name{balance_data}
\alias{balance_data}
\title{Balance Binary Data by Resampling: Under-Over Sampling}
\usage{
balance_data(df, variable, rate = 1, target = "auto", seed = 0, quiet = FALSE)
}
\arguments{
\item{df}{Vector or Dataframe. Contains different variables in each
column, separated by a specific character}

\item{variable}{Variable. Which variable should we used to re-sample dataset?}

\item{rate}{Numeric. How many X for every Y we need? Default: 1. If there are
more than 2 unique values, rate will represent percentage for number of rows}

\item{target}{Character. If binary, which value should be reduced? If kept in
\code{"auto"}, then the most frequent value will be reduced.}

\item{seed}{Numeric. Seed to replicate and obtain same values}

\item{quiet}{Boolean. Keep quiet? If not, messages will be printed}
}
\value{
data.frame. Reduced sampled data.frame following the \code{rate} of
appearance of a specific variable.
}
\description{
This function lets the user balance a given data.frame by resampling
with a given relation rate and a binary feature.
}
\examples{
data(dft) # Titanic dataset
df <- balance_data(dft, Survived, rate = 0.5)
df <- balance_data(dft, .data$Survived, rate = 0.1, target = "TRUE")
}
\seealso{
Other Data Wrangling: 
\code{\link{categ_reducer}()},
\code{\link{cleanText}()},
\code{\link{date_cuts}()},
\code{\link{date_feats}()},
\code{\link{file_name}()},
\code{\link{formatHTML}()},
\code{\link{holidays}()},
\code{\link{impute}()},
\code{\link{left}()},
\code{\link{normalize}()},
\code{\link{num_abbr}()},
\code{\link{ohe_commas}()},
\code{\link{ohse}()},
\code{\link{quants}()},
\code{\link{removenacols}()},
\code{\link{replaceall}()},
\code{\link{replacefactor}()},
\code{\link{textFeats}()},
\code{\link{textTokenizer}()},
\code{\link{vector2text}()},
\code{\link{year_month}()},
\code{\link{zerovar}()}
}
\concept{Data Wrangling}
