% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequencies.R
\name{freqs_list}
\alias{freqs_list}
\title{Frequencies on Lists and UpSet Plot}
\usage{
freqs_list(
  df,
  var = NULL,
  wt = NULL,
  fx = "mean",
  rm.na = FALSE,
  min_elements = 1,
  limit = 10,
  limit_x = NA,
  limit_y = NA,
  tail = TRUE,
  size = 10,
  unique = TRUE,
  abc = FALSE,
  title = "",
  plot = TRUE
)
}
\arguments{
\item{df}{Data.frame}

\item{var}{Variable. Variables you wish to process.}

\item{wt}{Variable, numeric. Select a numeric column to use
in the colour scale, used as sum, mean... of those values for each
of the combinations.}

\item{fx}{Character. Set operation: mean, sum}

\item{rm.na}{Boolean. Remove NA value from \code{wt}?}

\item{min_elements}{Integer. Exclude combinations with less than n elements}

\item{limit, limit_x, limit_y}{Integer. Show top n combinations (x) and/or
elements (y). The rest will be grouped into a single element.
Set argument to 0 to ignore. \code{limit_x}/\code{limit_y} answer to
\code{limit}'s argument.}

\item{tail}{Boolean. Show tail grouped into "..." on the plots?}

\item{size}{Numeric. Text base size}

\item{unique}{Boolean. a,b = b,a?}

\item{abc}{Boolean. Do you wish to sort by alphabetical order?}

\item{title}{Character. Overwrite plot's title with.}

\item{plot}{Boolean. Plot viz? Will be generated anyways in the output object}
}
\value{
List. data.frame with the data results, elements and combinations.
}
\description{
Visualize frequency of elements on a list, list vector, or vector with
comma separated values. Detect which combinations and elements are
the most frequent and how much they represent of your total observations.
This is similar to the \href{http://vcg.github.io/upset/}{UpSet Plots}
which may be used as an alternative to Venn diagrams.
}
\examples{
\dontrun{
df <- dplyr::starwars
head(df[, c(1, 4, 5, 12)], 10)

# Characters per movies combinations in a list column
head(df$films, 2)
freqs_list(df, films)

# Skin colours in a comma-separated column
head(df$skin_color)
x <- freqs_list(df, skin_color, min_elements = 2, limit = 5, plot = FALSE)
# Inside "x" we'll have:
names(x)

# Using the 'wt' argument to add a continuous value metric
# into an already one-hot encoded columns dataset (and hide tail)
csv <- "https://raw.githubusercontent.com/hms-dbmi/UpSetR/master/inst/extdata/movies.csv"
movies <- read.csv(csv, sep = ";")
head(movies)
freqs_list(movies,
  wt = AvgRating, min_elements = 2, tail = FALSE,
  title = "Movies\nMixed Genres\nRanking"
)
# So, please: no more Comedy+SciFi and more Drama+Horror films (based on ~50 movies)!
}
}
\seealso{
Other Frequency: 
\code{\link{freqs_df}()},
\code{\link{freqs_plot}()},
\code{\link{freqs}()}

Other Exploratory: 
\code{\link{corr_cross}()},
\code{\link{corr_var}()},
\code{\link{crosstab}()},
\code{\link{df_str}()},
\code{\link{distr}()},
\code{\link{freqs_df}()},
\code{\link{freqs_plot}()},
\code{\link{freqs}()},
\code{\link{lasso_vars}()},
\code{\link{missingness}()},
\code{\link{plot_cats}()},
\code{\link{plot_df}()},
\code{\link{plot_nums}()},
\code{\link{tree_var}()}

Other Visualization: 
\code{\link{distr}()},
\code{\link{freqs_df}()},
\code{\link{freqs_plot}()},
\code{\link{freqs}()},
\code{\link{noPlot}()},
\code{\link{plot_chord}()},
\code{\link{plot_survey}()},
\code{\link{plot_timeline}()},
\code{\link{tree_var}()}
}
\concept{Exploratory}
\concept{Frequency}
\concept{Visualization}
