% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_analytics.R
\name{queryGA}
\alias{queryGA}
\title{Queries on Google Analytics}
\usage{
queryGA(
  account,
  creds = NA,
  token_dir = NA,
  metrics = "sessions",
  dimensions = "date",
  met_filters = NULL,
  dim_filters = NULL,
  start = lubridate::floor_date(Sys.Date(), "month"),
  end = Sys.Date()
)
}
\arguments{
\item{account}{Character. Personal named accounts}

\item{creds}{Character. Credential's user (see \code{get_creds()})}

\item{token_dir}{Character. Credential's directory (see \code{get_creds()})}

\item{metrics}{Character. Which metrics we wish to bring}

\item{dimensions}{Character. Which dimensions we wish to bring}

\item{met_filters, dim_filters}{A \code{filter_clause_ga4} for filtering
metrics/dimensions. Check \code{googleAnalyticsR::google_analytics()}.}

\item{start}{Date. Start date for the report}

\item{end}{Date. End date for the report}
}
\value{
data.frame with the API GET request tabulated results.
}
\description{
This function lets the user query Google Analytics with its API.
More about the documentation and parameters in
\code{googleAnalyticsR::google_analytics()} or Google Analytics'
\href{https://ga-dev-tools.appspot.com/dimensions-metrics-explorer/}{API}
}
\seealso{
Other Credentials: 
\code{\link{db_download}()},
\code{\link{db_upload}()},
\code{\link{get_credentials}()},
\code{\link{get_tweets}()},
\code{\link{mail_send}()},
\code{\link{queryDB}()},
\code{\link{slackSend}()},
\code{\link{stocks_file}()},
\code{\link{stocks_report}()}

Other Google: 
\code{\link{filesGD}()},
\code{\link{gtrends_related}()},
\code{\link{readGS}()}

Other API: 
\code{\link{bring_api}()},
\code{\link{fb_accounts}()},
\code{\link{fb_ads}()},
\code{\link{fb_creatives}()},
\code{\link{fb_insights}()},
\code{\link{fb_process}()},
\code{\link{fb_report_check}()},
\code{\link{fb_rf}()},
\code{\link{fb_token}()},
\code{\link{gpt_ask}()},
\code{\link{li_auth}()},
\code{\link{li_profile}()},
\code{\link{slackSend}()}
}
\concept{API}
\concept{Credentials}
\concept{Google}
