% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robyn.R
\name{robyn_marginal}
\alias{robyn_marginal}
\title{Robyn: Marginal Performance (mROAS & mCPA) [Experimental]}
\usage{
robyn_marginal(..., marginal_unit = 1)
}
\arguments{
\item{...}{Additional parameters.}

\item{marginal_unit}{Additional units to calculate the marginal performance.}
}
\value{
list with base and marginal response results, marginal performance
metric and value, and plot.
}
\description{
Calculate and plot marginal performance of any spend or organic variable.
}
\examples{
\dontrun{
# You may load an exported model to recreate Robyn objects
mod <- Robyn::robyn_recreate(json_file = "your_model.json")
robyn_marginal(
  InputCollect = mod$InputCollect,
  OutputCollect = mod$OutputCollect,
  metric_name = "emails_O",
  metric_value = 100000,
  date_range = "all",
  marginal_unit = 10000000
)
}
}
\seealso{
Other Robyn: 
\code{\link{robyn_hypsbuilder}()},
\code{\link{robyn_modelselector}()},
\code{\link{robyn_performance}()}
}
\concept{Robyn}
