#include "largeList.h"

extern "C" SEXP readList(SEXP file, SEXP index = R_NilValue)
{ 
  //check parameters
  if (TYPEOF(file) != STRSXP || Rf_length(file) > 1) error("File should be a charater vector of length 1.\n");
  if (index != R_NilValue && TYPEOF(index) != INTSXP &&  TYPEOF(index) != REALSXP && TYPEOF(index) != STRSXP)
    error("Index should be a NULL, an integer vector, a numeric vector or a character vector.\n");
  
  const char *fileName = getFullPath(file);
  if(checkFile(fileName) == false) error("File does not exist!\n");
  FILE *fin = fopen(fileName, "rb");
  
  //get file length
  fseek(fin, 0, SEEK_END);
  int64_t fileSize = ftell(fin);
  
  //get list length
  fseek(fin, 18, SEEK_SET);
  int lengthOfList;
  fread((char*)&(lengthOfList), 4, 1, fin);

  std::vector<int64_t> positions;
  std::vector<int> indexNum;
  std::vector<std::string> names;
  
  //if index is not given.
  if (index == R_NilValue){
    indexNum.resize(lengthOfList);
    for(int i = 0 ; i < lengthOfList; i++){
      indexNum[i] = i;
    }
    positions.resize(indexNum.size());
    names.resize(indexNum.size());
    for(int i = 0 ; i < lengthOfList; i++){
      fseek(fin, -2*(8+NAMELENGTH)*lengthOfList-8+(indexNum[i])*(8+NAMELENGTH), SEEK_END);
      fread((char*)&(positions[i]), 8, 1, fin); 
      names[i].resize(NAMELENGTH);
      fread((char*)&(names[i][0]), NAMELENGTH, 1, fin);
    }
  }
  
  //check if given index is numeric.
  if (TYPEOF(index) == INTSXP ||  TYPEOF(index) == REALSXP){
    indexNum.resize(Rf_length(index));
    TYPEOF(index) == INTSXP ?
      indexNum.assign(INTEGER(index),INTEGER(index)+Rf_length(index)) :
      indexNum.assign(REAL(index),REAL(index)+Rf_length(index));
    for(int i = 0 ; i < Rf_length(index); i++){
      indexNum[i] = indexNum[i]-1;
    }
    //check the range of indicies
    int maxIndex = *std::max_element(indexNum.begin(), indexNum.end());
    int minIndex = *std::min_element(indexNum.begin(), indexNum.end());
    if (minIndex < 0){
      fclose(fin);
      error("Index should be positive.\n");
    }
    if (maxIndex > lengthOfList-1){
      fclose(fin);
      error("Index beyonds list length.\n");
    }
    positions.resize(indexNum.size());
    names.resize(indexNum.size());
    for(int i = 0 ; i < Rf_length(index); i++){
      fseek(fin, -2*(8+NAMELENGTH)*lengthOfList-8+(indexNum[i])*(8+NAMELENGTH), SEEK_END);
      fread((char*)&(positions[i]), 8, 1, fin); 
      names[i].resize(NAMELENGTH);
      fread((char*)&(names[i][0]), NAMELENGTH, 1, fin);
    }
  }
  
  if (TYPEOF(index) == STRSXP){
    names.resize(Rf_length(index));
    for (int i = 0; i < Rf_length(index); i ++){
      names[i].assign(CHAR(STRING_ELT(index,i)),Rf_length(STRING_ELT(index,i)));
    }
    positions.resize(names.size());
    indexNum.resize(names.size());
    for(int i = 0 ; i < Rf_length(index); i++){
      names[i].resize(NAMELENGTH);
      fileBinarySearch(fin, positions[i], names[i], indexNum[i], lengthOfList);
    }
  }
  
  //get elements.
  int64_t indexSize = positions.size();
  SEXP outputList = PROTECT(Rf_allocVector(VECSXP, indexSize));
  for (int i = 0; i <indexSize; i++ ){
    if (positions[i] == -1){
      Rf_warning("Element %s not found! \n", names[i].c_str());
      SET_VECTOR_ELT(outputList,i,R_NilValue);
    }else{
      if (positions[i] > fileSize ){
        Rprintf("index %d ,headPosition %lf, fileSize %lf", i, (double)positions[i], (double)fileSize);
        fclose(fin);
        error("Head position exceeds file length. Maybe the file is not generated by saveLargeList function.");
      }
      fseek(fin, positions[i], SEEK_SET);
      SEXP element = PROTECT(readSEXP(fin));
      SET_VECTOR_ELT(outputList,i,element);
      UNPROTECT_PTR(element);
    }
  }
  
  //get names
  SEXP namesSXP = PROTECT(Rf_allocVector(STRSXP, indexSize));
  std::string naString(NAMELENGTH,'\xff');
  for (int i = 0; i <indexSize; i++ ){
      names[i] == naString ? 
      SET_STRING_ELT(namesSXP, i, NA_STRING) :
      SET_STRING_ELT(namesSXP, i, Rf_mkChar(names[i].c_str()));
  }
  //set names
  Rf_setAttrib(outputList,R_NamesSymbol,namesSXP);
  fclose(fin); 
  UNPROTECT(2);
  return(outputList);
}
