% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Exports.R
\name{modifyInList}
\alias{modifyInList}
\title{Modify elements in a list file.}
\usage{
modifyInList(file, index, object)
}
\arguments{
\item{file}{Name of file.}

\item{index}{A numeric, logical or character vector.}

\item{object}{A list consisting of replacement values.}
}
\value{
invisible \code{TRUE} if no error occurs.
}
\description{
Modify elements in a list file.
}
\details{
It modifies elements with given indices by replacement values provided in parameter object. If length 
of replacement values is shorter than length of indices, values will be used circularly. This function may 
relocate all the data in the stored file, thus can be very slow! Please consider to call this
function batchwise instead of one by one.
}
\examples{
list1 <- list("A" = c(1,2), "B" = "abc", list(1, 2, 3))
saveList(list1, "example.llo")
modifyInList("example.llo", c(1,2), list("AA","BB"))
modifyInList("example.llo", c("AA","BB"), list("A","B"))
}
\seealso{
\code{\link{largeList}}
}

