% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance.R
\name{distance}
\alias{distance}
\alias{distance.matrix}
\alias{distance.CsparseMatrix}
\alias{distance.TsparseMatrix}
\title{Calculate pairwise Euclidean or angular distances efficiently}
\usage{
distance(x, i, j, distance_method, threads = NULL, verbose)

\method{distance}{matrix}(x, i, j, distance_method = "Euclidean",
  threads = NULL, verbose = getOption("verbose", TRUE))

\method{distance}{CsparseMatrix}(x, i, j, distance_method = "Euclidean",
  threads = NULL, verbose = getOption("verbose", TRUE))

\method{distance}{TsparseMatrix}(x, i, j, distance_method = "Euclidean",
  threads = NULL, verbose = getOption("verbose", TRUE))
}
\arguments{
\item{x}{A (potentially sparse) matrix, where examples are columns and features are rows.}

\item{i}{0-indexed vector of column indices.}

\item{j}{0-indexed vector of column indices.}

\item{distance_method}{One of "Euclidean" or "Cosine."}

\item{threads}{The maximum number of threads to spawn. Determined automatically if \code{NULL} (the default).}

\item{verbose}{Verbosity.}
}
\value{
A vector of the distances between the columns in `x` indexed by `i` and `j`, with attribute \code{method} giving the \code{distance_method}.
}
\description{
This function is a wrapper around a C++ function that calculates pairwise distances in a memory- and CPU-efficient manner.
}
\details{
The Euclidean or angular distances between columns in `x` identified by parameters `i` and `j` are calculated and returned.
}
