% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodFlexmix.R
\name{lcMethodFlexmix}
\alias{lcMethodFlexmix}
\title{Method interface to flexmix()}
\usage{
lcMethodFlexmix(
  formula,
  formula.mb = ~1,
  time = getOption("latrend.time"),
  id = getOption("latrend.id"),
  nClusters = 2,
  ...
)
}
\arguments{
\item{formula}{A \code{formula} specifying the model.}

\item{formula.mb}{A \code{formula} specifying the class membership model. By default, an intercept-only model is used.}

\item{time}{The name of the time variable.}

\item{id}{The name of the trajectory identifier variable.}

\item{nClusters}{The number of clusters to estimate.}

\item{...}{Arguments passed to \link[flexmix:flexmix]{flexmix::flexmix}.
The following arguments are ignored: data, concomitant, k.}
}
\description{
Wrapper to the \code{flexmix()} method from the \code{flexmix} package.
}
\examples{
library(flexmix)
data(latrendData)
method <- lcMethodFlexmix(Y ~ Time, id = "Id", time = "Time", nClusters = 3)
model <- latrend(method, latrendData)
}
\seealso{
Other lcMethod package interfaces: 
\code{\link{lcMethodFlexmixGBTM}}
}
\concept{lcMethod package interfaces}
