% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta-fit.R, R/meta-fit-converged.R,
%   R/meta-fit-rep.R
\docType{class}
\name{lcFitMethods}
\alias{lcFitMethods}
\alias{lcFitConverged-class}
\alias{lcFitConverged}
\alias{lcFitRep-class}
\alias{lcFitRep}
\alias{lcFitRepMin}
\alias{lcFitRepMax}
\title{Method fit modifiers}
\usage{
lcFitConverged(method, maxRep = Inf)

lcFitRep(method, rep = 10, metric, maximize)

lcFitRepMin(method, rep = 10, metric)

lcFitRepMax(method, rep = 10, metric)
}
\arguments{
\item{method}{The \code{lcMethod} to use for fitting.}

\item{maxRep}{The maximum number of fit attempts}

\item{rep}{The number of fits}

\item{metric}{The internal metric to assess the fit.}

\item{maximize}{Whether to maximize the metric. Otherwise, it is minimized.}
}
\description{
A collection of special methods that adapt the fitting procedure of the underlying longitudinal cluster method.
Supported fit methods:
\itemize{
\item \code{lcFitConverged}: Fit a method until a converged result is obtained.
\item \code{lcFitRep}: Repeatedly fit a method and return the best result based on a given internal metric.
\item \code{lcFitRepMin}: Repeatedly fit a method and return the best result that minimizes the given internal metric.
\item \code{lcFitRepMax}: Repeatedly fit a method and return the best result that maximizes the given internal metric.
}
}
\examples{

data(latrendData)
method <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time", nClusters = 2)
metaMethod <- lcFitConverged(method, maxRep = 10)
metaMethod
model <- latrend(metaMethod, latrendData)

data(latrendData)
method <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time", nClusters = 2)
repMethod <- lcFitRep(method, rep = 10, metric = "RSS", maximize = FALSE)
repMethod
model <- latrend(repMethod, latrendData)

minMethod <- lcFitRepMin(method, rep = 10, metric = "RSS")

maxMethod <- lcFitRepMax(method, rep = 10, metric = "ASW")
}
