% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latrend.R
\name{latrendBoot}
\alias{latrendBoot}
\title{Cluster longitudinal data using bootstrapping}
\usage{
latrendBoot(
  method,
  data,
  samples = 50,
  seed = NULL,
  parallel = FALSE,
  errorHandling = "stop",
  envir = NULL,
  verbose = getOption("latrend.verbose")
)
}
\arguments{
\item{method}{An \link{lcMethod} object specifying the longitudinal cluster method to apply, or the name (as \code{character}) of the \code{lcMethod} subclass to instantiate.}

\item{data}{A \code{data.frame}.}

\item{samples}{The number of bootstrap samples to evaluate.}

\item{seed}{The seed to use. Optional.}

\item{parallel}{Whether to enable parallel evaluation. See \link{latrend-parallel}. Method evaluation and dataset transformation is done on the calling thread.}

\item{errorHandling}{Whether to \code{"stop"} on an error, or to \verb{"remove'} evaluations that raised an error.}

\item{envir}{The \code{environment} in which to evaluate the method arguments via \code{\link[=compose]{compose()}}.
If the \code{data} argument is of type \code{call} then this environment is also used to evaluate the \code{data} argument.}

\item{verbose}{The level of verbosity. Either an object of class \code{Verbose} (see \link[R.utils:Verbose]{R.utils::Verbose} for details),
a \code{logical} indicating whether to show basic computation information,
a \code{numeric} indicating the verbosity level (see \link{Verbose}),
or one of \code{c('info', 'fine', 'finest')}.}
}
\value{
A \code{lcModels} object of length \code{samples}.
}
\description{
Performs bootstrapping, generating samples from the given data at the id level, fitting a lcModel to each sample.
}
\examples{
data(latrendData)
method <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time")
bootModels <- latrendBoot(method, latrendData, samples = 10)

bootMAE <- metric(bootModels, name = "MAE")
mean(bootMAE)
sd(bootMAE)
}
\seealso{
Other longitudinal cluster fit functions: 
\code{\link{latrend}()},
\code{\link{latrendBatch}()},
\code{\link{latrendCV}()},
\code{\link{latrendRep}()}

Other validation methods: 
\code{\link{createTestDataFold}()},
\code{\link{createTestDataFolds}()},
\code{\link{createTrainDataFolds}()},
\code{\link{latrendCV}()},
\code{\link{lcModel-data-filters}}
}
\concept{longitudinal cluster fit functions}
\concept{validation methods}
