% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/method.R
\name{preFit}
\alias{preFit}
\alias{preFit,lcMethod-method}
\title{\code{lcMethod} estimation step: method preparation logic}
\usage{
preFit(method, data, envir, verbose, ...)

\S4method{preFit}{lcMethod}(method, data, envir, verbose)
}
\arguments{
\item{method}{An object inheriting from \code{lcMethod} with all its arguments having been evaluated and finalized.}

\item{data}{A \code{data.frame} representing the transformed training data.}

\item{envir}{The \code{environment} containing additional data variables returned by \code{\link[=prepareData]{prepareData()}}.}

\item{verbose}{A \link[R.utils:Verbose]{R.utils::Verbose} object indicating the level of verbosity.}

\item{...}{Not used.}
}
\value{
The updated \code{environment} that will be passed to \code{\link[=fit]{fit()}}.
}
\description{
Note: this function should not be called directly, as it is part of the \code{lcMethod} \link[=lcMethod-estimation]{estimation procedure}.
For fitting an \code{lcMethod} object to a dataset, use the \code{\link[=latrend]{latrend()}} function or \link[=latrend-estimation]{one of the other standard estimation functions}.

The \code{preFit()} function of the \code{lcMethod} object performs preparatory work that is needed for fitting the method but should not be counted towards the method estimation time.
The work is added to the provided \code{environment}, allowing the \code{\link[=fit]{fit()}} function to make use of the prepared work.
}
\section{Implementation}{

\preformatted{
setMethod("preFit", "lcMethodExample", function(method, data, envir, verbose) {
  # update envir with additional computed work
  envir$x <- INTENSIVE_OPERATION
  return(envir)
})
}
}

\section{Estimation procedure}{

The steps for estimating a \code{lcMethod} object are defined and executed as follows:
\enumerate{
\item \code{\link[=compose]{compose()}}: Evaluate and finalize the method argument values.
\item \code{\link[=validate]{validate()}}: Check the validity of the method argument values in relation to the dataset.
\item \code{\link[=prepareData]{prepareData()}}: Process the training data for fitting.
\item \code{\link[=preFit]{preFit()}}: Prepare environment for estimation, independent of training data.
\item \code{\link[=fit]{fit()}}: Estimate the specified method on the training data, outputting an object inheriting from \code{lcModel}.
\item \code{\link[=postFit]{postFit()}}: Post-process the outputted \code{lcModel} object.
}

The result of the fitting procedure is an \linkS4class{lcModel} object that inherits from the \code{lcModel} class.
}

