% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formLattice.R
\name{formLattice}
\alias{formLattice}
\title{Builds a neighbor structure on the nodes.}
\usage{
formLattice(nodeFillingOutput)
}
\arguments{
\item{nodeFillingOutput}{An object, as produced by the function nodeFilling.}
}
\value{
formLatticeOutput object
\itemize{
  \item EW_locs EW coordinates for use by contour
  \item NS_locs NS coordinates for use by contour
  \item nodes Matrix of node locations.
  \item poly Outer boundary.
  \item latt Neighbor lattice.
  \item hole.poly List of hole polygons.}
}
\description{
formLattice connects all nodes into a 
neighbor lattice by linking any two 
nodes that are within 1.5*node_spacing. 
Typically this will result in links in 
the E, W, N, S, NE, NW, SE, SW directions. 
The lattice object is created by the 
function dnearneigh from spdep.
}
\details{
When forming the lattice, the function does not 
check to see if any node is completely isolated 
from the rest of the nodes, nor does it check 
to see that paths exist between all pairs of nodes. 
Thus the lattice might be disconnected. You can 
still determine a nonparametric density in this 
case, but you need to think about whether it makes 
sense to allow disconnected sublattices. If you wish 
to connect isolated nodes to the lattice, use the 
editing function editLattice.
}
\examples{
plot.new()
data(polygon1)
nodeFillingOutput <- nodeFilling(poly=polygon1, node_spacing=0.02)
plot(nodeFillingOutput)
formLatticeOutput <- formLattice(nodeFillingOutput)
plot(formLatticeOutput)
Pointdata <- splancs::csr(polygon1,80)
Pointdata <- Pointdata[Pointdata[,1]<0.5,]
plot(polygon1,type="n")
polygon(polygon1)
points(Pointdata,pch=19)
densityOut <- createDensity(formLatticeOutput,PointPattern=Pointdata,
                           k=20,intensity=FALSE, sparse = TRUE)
plot(densityOut)
homerange(densityOut, percent = 0.95)


}
\references{
Ronald P. Barry, Julie McIntyre. 
Estimating animal densities and home 
range in regions with irreg- ular boundaries 
and holes: A lattice-based alternative to the 
kernel density estimator. Ecological Modelling 
222 (2011) 1666-1672.
}
\author{
Ronald P. Barry
}
