\name{Missing}
\alias{Missing}
\title{Missing value generator}
\usage{
Missing(object, formula, Rformula, ...)
}
\arguments{
  \item{object}{\code{lvm}-object.}

  \item{formula}{The right hand side specifies the name of
  a latent variable which is not always observed. The left
  hand side specifies the name of a new variable which is
  equal to the latent variable but has missing values.}

  \item{Rformula}{The left hand side specifies the name of
  the missing value indicator}

  \item{...}{Passed to binomial.lvm.}
}
\value{
lvm object
}
\description{
Missing value generator
}
\details{
This function adds a binary variable to a given \code{lvm}
model and also a variable which is equal to the original
variable where the binary variable is
}
\examples{
library(lava)
set.seed(17)
m <- lvm(y0~x01+x02+x03)
m <- Missing(m,formula=x1~x01,Rformula=R1~0.3*x02+-0.7*x01,p=0.4)
sim(m,10)
}
\author{
Thomas A. Gerds <tag@biostat.ku.dk>
}

