% Generated by roxygen2 (4.0.2.9000): do not edit by hand
% Please edit documentation in R/iid.R
\name{iid}
\alias{iid}
\alias{iid.default}
\title{Extract i.i.d. decomposition (influence function) from model object}
\usage{
iid(x,...)

\method{iid}{default}(x,bread,id,...)
}
\arguments{
\item{x}{model object}

\item{...}{additional arguments}

\item{id}{id/cluster variable (optional)}

\item{bread}{(optional) Inverse of derivative of mean score function}
}
\description{
Extract i.i.d. decomposition (influence function) from model object
}
\examples{
m <- lvm(y~x+z)
distribution(m, ~y+z) <- binomial.lvm("logit")
d <- sim(m,1e3)
g <- glm(y~x+z,data=d,family=binomial)
crossprod(iid(g))
}

