% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/point_on_line.R
\name{lawn_point_on_line}
\alias{lawn_point_on_line}
\title{Get closest point on linestring to reference point}
\usage{
lawn_point_on_line(line, point, lint = FALSE)
}
\arguments{
\item{line}{line to snap to}

\item{point}{point to snap from}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing time
as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good geojson
objects. Default: \code{FALSE}}
}
\value{
A \code{\link{data-Point}}
}
\description{
Takes a line, a start \code{\link{data-Point}}, and a stop point and returns
the line in between those points
}
\examples{
line <- '{
  "type": "Feature",
  "properties": {},
  "geometry": {
    "type": "LineString",
    "coordinates": [
      [-77.031669, 38.878605],
      [-77.029609, 38.881946],
      [-77.020339, 38.884084],
      [-77.025661, 38.885821],
      [-77.021884, 38.889563],
      [-77.019824, 38.892368]
    ]
  }
}'
pt <- '{
  "type": "Feature",
  "properties": {},
  "geometry": {
    "type": "Point",
    "coordinates": [-77.037076, 38.884017]
  }
}'
lawn_point_on_line(line, pt)

# lint input objects
lawn_point_on_line(line, pt, TRUE)
}

