% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/featurecollection.R
\name{lawn_featurecollection}
\alias{lawn_featurecollection}
\title{Create a FeatureCollection}
\usage{
lawn_featurecollection(features)
}
\arguments{
\item{features}{Input features, can be json as json or character class,
or a point, polygon, linestring, or centroid class, or many of those
things in a list.}
}
\description{
Create a FeatureCollection
}
\examples{
\dontrun{
# points
## single point
pt <- lawn_point(c(-75.343, 39.984), properties = list(name = 'Location A'))
lawn_featurecollection(pt)

## many points in a list
features <- list(
   lawn_point(c(-75.343, 39.984), properties = list(name = 'Location A')),
   lawn_point(c(-75.833, 39.284), properties = list(name = 'Location B')),
   lawn_point(c(-75.534, 39.123), properties = list(name = 'Location C'))
)
lawn_featurecollection(features)

# polygons
rings <- list(list(
   c(-2.275543, 53.464547),
   c(-2.275543, 53.489271),
   c(-2.215118, 53.489271),
   c(-2.215118, 53.464547),
   c(-2.275543, 53.464547)
))
## single polygon
lawn_featurecollection(lawn_polygon(rings))

## many polygons in a list
rings2 <- list(list(
   c(-2.775543, 54.464547),
   c(-2.775543, 54.489271),
   c(-2.245118, 54.489271),
   c(-2.245118, 54.464547),
   c(-2.775543, 54.464547)
))
features <- list(
   lawn_polygon(rings, properties = list(name = 'poly1', population = 400)),
   lawn_polygon(rings2, properties = list(name = 'poly2', population = 5000))
)
lawn_featurecollection(features)

# linestrings
pts1 <- list(
   c(-2.364416, 53.448203),
   c(-2.356176, 53.441316),
   c(-2.33901, 53.435924),
   c(-2.327337, 53.436673)
)
## single linestring
lawn_featurecollection(lawn_linestring(pts1))

## many linestring's in a list
pts2 <- rapply(pts1, function(x) x+0.1, how = "list")
features <- list(
   lawn_linestring(pts1, properties = list(name = 'line1', distance = 145)),
   lawn_linestring(pts2, properties = list(name = 'line2', distance = 145))
)
lawn_featurecollection(features)

# mixed feature set: polygon, linestring, and point
features <- list(
   lawn_polygon(rings, properties = list(name = 'poly1', population = 400)),
   lawn_linestring(pts1, properties = list(name = 'line1', distance = 145)),
   lawn_point(c(-2.25, 53.479271), properties = list(name = 'Location A'))
)
lawn_featurecollection(features)

# Return self if a featurecollection class passed
res <- lawn_featurecollection(features)
lawn_featurecollection(res)

# json featurecollection passed in
library("jsonlite")
str <- toJSON(unclass(res))
lawn_featurecollection(str)

# from a centroid object
poly <- '{
  "type": "Feature",
  "properties": {},
  "geometry": {
    "type": "Polygon",
    "coordinates": [[
      [105.818939,21.004714],
      [105.818939,21.061754],
      [105.890007,21.061754],
      [105.890007,21.004714],
      [105.818939,21.004714]
     ]]
  }
}'
cent <- lawn_centroid(poly)
lawn_featurecollection(cent)

# from a feature
pt <- '{
 "type": "Feature",
 "properties": {},
 "geometry": {
   "type": "Point",
   "coordinates": [-90.548630, 14.616599]
  }
}'
x <- lawn_buffer(pt, 5)
lawn_featurecollection(x)

# From a geo_list object from geojsonio package
# library("geojsonio")
# vecs <- list(c(100.0,0.0), c(101.0,0.0), c(101.0,1.0), c(100.0,1.0),
#   c(100.0,0.0))
# x <- geojson_list(vecs, geometry="polygon")
# lawn_featurecollection(x)
}
}
\seealso{
Other data functions: 
\code{\link{lawn_feature}()},
\code{\link{lawn_filter}()},
\code{\link{lawn_geometrycollection}()},
\code{\link{lawn_linestring}()},
\code{\link{lawn_multilinestring}()},
\code{\link{lawn_multipoint}()},
\code{\link{lawn_multipolygon}()},
\code{\link{lawn_point}()},
\code{\link{lawn_polygon}()},
\code{\link{lawn_random}()},
\code{\link{lawn_remove}()},
\code{\link{lawn_sample}()}
}
\concept{data functions}
