% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.R
\name{anova.lax}
\alias{anova.lax}
\title{Comparison of nested models}
\usage{
\method{anova}{lax}(object, object2, ...)
}
\arguments{
\item{object}{An object of class \code{"lax"}, inheriting from class
\code{"chandwich"}, returned by \code{\link{alogLik}}.}

\item{object2}{An object of class \code{"lax"}, inheriting from class
\code{"chandwich"}, returned by \code{\link{alogLik}}.}

\item{...}{Further objects of class \code{"lax"} and/or arguments
to be passed to \code{\link[chandwich]{anova.chandwich}}, and then on to
\code{\link[chandwich]{compare_models}}, in particular \code{type}, which
chooses the type of adjustment.}
}
\value{
An object of class \code{"anova"} inheriting from class
 \code{"data.frame"}, with four columns:
    \item{Model.Df}{The number of parameters in the model}
    \item{Df}{The decrease in the number of parameter compared the model
      in the previous row}
    \item{ALRTS}{The adjusted likelihood ratio test statistic}
    \item{Pr(>ALRTS)}{The p-value associated with the test that the
      model is a valid simplification of the model in the previous row.}
 The row names are the names of the model objects.
}
\description{
\code{anova} method for objects of class \code{"lax"}.
Compares two or more nested models using the adjusted likelihood ratio
test statistic (ALRTS) described in Section 3.5 of Chandler and Bate (2007).
The nesting must result from the simple constraint that a subset of the
parameters of the larger model is held fixed.
}
\details{
The objects of class \code{"lax"} need not be provided in nested
  order: they will be ordered inside \code{anova.lax} based on the
  values of \code{attr(., "p_current")}.
}
\examples{
got_evd <- requireNamespace("evd", quietly = TRUE)
if (got_evd) {
  library(evd)
  small <- fgev(ow$temp, nsloc = ow[, "loc"])
  adj_small <- alogLik(small, cluster = ow$year)
  tiny <- fgev(ow$temp)
  adj_tiny <- alogLik(tiny, cluster = ow$year)
  anova(adj_small, adj_tiny)

  set.seed(4082019)
  uvdata <- evd::rgev(100, loc = 0.13, scale = 1.1, shape = 0.2)
  M0 <- fgev(uvdata)
  M1 <- fgev(uvdata, nsloc = (-49:50)/100)
  adj0 <- alogLik(M0)
  adj1 <- alogLik(M1)
  anova(adj1, adj0)
}

got_texmex <- requireNamespace("texmex", quietly = TRUE)
if (got_texmex) {
  library(texmex)
  large <- evm(temp, ow, gev, mu = ~ loc, phi = ~ loc, xi = ~loc)
  medium <- evm(temp, ow, gev, mu = ~ loc, phi = ~ loc)
  small <- evm(temp, ow, gev, mu = ~ loc)
  tiny <- evm(temp, ow, gev)
  adj_large<- alogLik(large, cluster = ow$year)
  adj_medium <- alogLik(medium, cluster = ow$year)
  adj_small <- alogLik(small, cluster = ow$year)
  adj_tiny <- alogLik(tiny, cluster = ow$year)
  anova(adj_large, adj_medium, adj_small, adj_tiny)
}
}
\references{
Chandler, R. E. and Bate, S. (2007). Inference for clustered
  data using the independence loglikelihood. \emph{Biometrika},
  \strong{94}(1), 167-183. \doi{10.1093/biomet/asm015}
}
\seealso{
\code{\link[chandwich]{anova.chandwich}}: the \code{anova} method
  on which \code{anova.lax} is based.

\code{\link{alogLik}}: loglikelihood adjustment for model fits.
}
