% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rl_write_control_parameters.R
\name{rl_write_control_parameters}
\alias{rl_write_control_parameters}
\title{Function to find and write the best control parameters.}
\usage{
rl_write_control_parameters(
  x,
  path_control_files,
  num_trades_to_consider = 100
)
}
\arguments{
\item{x}{- dataset containing the trading results for one trading robot}

\item{path_control_files}{- path where control parameters will be saved}

\item{num_trades_to_consider}{- number of last trades to use for RL modeling simulations, default value 100}
}
\value{
Function writes best control parameters to be used by the Reinforcement Learning Function
}
\description{
This function is supposed to run on a weekly basis. Purpose of this function is to perform RL and
trading simulation and find out the best possible control parameters for the RL function.
}
\details{
Function is used by the R script Adapt_RL_control.R
}
\examples{

\donttest{

dir <- normalizePath(tempdir(),winslash = "/")
#test lasts 15 sec:
library(dplyr)
library(readr)
library(ReinforcementLearning)
library(magrittr)
library(lazytrade)
data(data_trades)
x <- data_trades
rl_write_control_parameters(x = data_trades,
                            path_control_files = dir,
                            num_trades_to_consider = 20)

}

}
\author{
(C) 2019 Vladimir Zhbanko
}
