# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Rcpp function to compute constant used in \code{spectraldensity} evaluation
#'
#' @param rho parameter of limiting model corresponding to index of regular variation
#' @param alpha vector of Dirichlet allocations (must be a vector of integers)
#' 
#' @keywords internal
#' 
#' @return a constant
.dens_const <- function(alpha, rho) {
    .Call('lcopula_dens_const', PACKAGE = 'lcopula', alpha, rho)
}

#' Rcpp function to compute constant factor used in \code{spectraldensity} evaluation
#'
#' @param rho parameter of limiting model corresponding to index of regular variation
#' @param index the summation index corresponding to current factor
#' 
#' @keywords internal
#' 
#' @return a constant
.b <- function(index, rho = as.numeric( c(1.0))) {
    .Call('lcopula_b_const', PACKAGE = 'lcopula', index, rho)
}

#' Rcpp function for the spectral density of the Liouville EV model.
#' 
#' Function used to plot the spectral density function. Not well-defined at endpoints.
#'
#' @param w pseudo-angle between (0,1) at which to eveluate the spectraldensity of the CDA of C
#' @param alphavec vector of Dirichlet allocations (must be a vector of integers)
#' @param rho parameter of limiting model corresponding to index of regular variation
#' 
#' 
#' @return Vector of values of spectral density at \code{w}
.spectraldensity <- function(w, alphavec, rho) {
    .Call('lcopula_spectraldensity', PACKAGE = 'lcopula', w, alphavec, rho)
}

#' Rcpp function to compute sum of rows and couple according to alphavec
#'
#' @param mc a matrix of Archimedean vectors to share of dimension \code{sum(alphavec)}
#' @param alphavec vector of Dirichlet allocations (must be a vector of integers)
#' 
#' @keywords internal
#' 
#' @return a matrix of dimension \code{n} by \code{length(alphavec)} with combined data
.marginCombo <- function(alphavec, mc) {
    .Call('lcopula_marginCombo', PACKAGE = 'lcopula', alphavec, mc)
}

