% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/liouville.R
\name{sliouv}
\alias{sliouv}
\title{Joint survival function for Liouville copulas}
\usage{
sliouv(theta, data, family, alphavec)
}
\arguments{
\item{theta}{parameter of the corresponding Archimedean copula}

\item{data}{sample matrix from a Liouville copula}

\item{family}{family of the Liouville copula. Either \code{"clayton"}, \code{"gumbel"}, \code{"frank"}, \code{"AMH"} or \code{"joe"}}

\item{alphavec}{vector of Dirichlet allocations (must be a vector of integers)}
}
\value{
a matrix of survival probabilities
}
\description{
Joint survival function for Liouville copulas
}
\examples{
x <- rliouv(n = 100, family = "clayton", alphavec <- c(2,3), theta = 2)
sliouv(data=x, family="clayton", alphavec=c(2,3), theta=2)
}

