% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeRepTopics.R
\name{mergeRepTopics}
\alias{mergeRepTopics}
\alias{mergeRepTopics.LDARep}
\alias{mergeRepTopics.default}
\title{Merge LDA Topic Matrices}
\usage{
mergeRepTopics(...)

\method{mergeRepTopics}{LDARep}(x, vocab, progress = TRUE, ...)

\method{mergeRepTopics}{default}(lda, vocab, id, progress = TRUE, ...)
}
\arguments{
\item{...}{additional arguments}

\item{x}{[\code{named list}]\cr
\code{\link{LDARep}} object. Alternatively \code{lda} and \code{id} can be passed.}

\item{vocab}{[\code{character}]\cr
Vocabularies taken into consideration for merging topic matrices. Default is
the vocabulary of the first LDA.}

\item{progress}{[\code{logical(1)}]\cr
Should a nice progress bar be shown? Turning it off, could lead to significantly
faster calculation. Default ist \code{TRUE}.}

\item{lda}{[\code{named list}]\cr
List of \code{\link{LDA}} objects, named by the corresponding "job.id".}

\item{id}{[\code{character(1)}]\cr
Name for the computation. Default is "LDARep".}
}
\value{
[\code{named matrix}] with the count of vocabularies (row wise) in topics (column wise).
}
\description{
Collects LDA results from a list of replicated runs and merges their topic
matrices for a given set of vocabularies.
}
\details{
For details and examples see \code{\link{mergeTopics}}.
}
\seealso{
Other merge functions: 
\code{\link{mergeBatchTopics}()},
\code{\link{mergeTopics}()}

Other replication functions: 
\code{\link{LDAPrototype}()},
\code{\link{LDARep}()},
\code{\link{as.LDARep}()},
\code{\link{getJob}()}
}
\concept{merge functions}
\concept{replication functions}
