% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_exhaustive.R
\name{.decrease_group_sizes}
\alias{.decrease_group_sizes}
\title{Creates all group sizes by reducing one group in all rows of grpsizes.}
\usage{
.decrease_group_sizes(grpsizes, grpnames, minpergrp)
}
\arguments{
\item{grpsizes}{A data.table with the columns containing the group names,
and the rows containing a particular setup of group sizes.
All rows are expected to have the same sum (not checked).}

\item{grpnames}{The group names (specified because the table can have other
columns as well).}

\item{minpergrp}{The minimum number of subjects to be preserved per group.}
}
\value{
A data.table with the same format as grpsizes, containing all
possible group setups totaling to one less than the total in grpsizes.
}
\description{
Used for generating all group size combinations for one specific total size
iteratively, starting from grpsizes with one row containing original group
sizes.
}
\keyword{internal}
