% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{.foreach}
\alias{.foreach}
\title{Wrapper to foreach::foreach called from .choose_best_subjects.}
\usage{
.foreach(
  input,
  operation,
  preprocess_input,
  .init,
  .combine,
  max_chunk_size = get("PROCESSED_CHUNK_SIZE", .ldamatch_globals),
  print_progress = get("PRINT_PROGRESS", .ldamatch_globals)
)
}
\arguments{
\item{input}{An iterator created using either the iterpc or the iterators
package, or anything else foreach::foreach can interpret (esp. a list).}

\item{operation}{The operation to be performed for each item in input
(possibly after preprocessing it; see preprocess_input).}

\item{preprocess_input}{Processes each value retrieved from the input iterator.}

\item{.init, .combine}{The same as the parameters of foreach::foreach
with identical names.}

\item{max_chunk_size}{The maximum number of items to be retrieved from input
if it is an iterator.}

\item{print_progress}{If TRUE, prints messages about the progress.

Used to use iterpc::iter_wrapper() on iterpc iterators, but realized that
foreach doesn't handle iterators in a nice way (converts it to a list, which
may be huge, instead of gradually retrieving the contensts), so feeding
segments of the iterators to foreach instead.}
}
\description{
Wrapper to foreach::foreach called from .choose_best_subjects.
}
\keyword{internal}
